/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <code>ListTagsForStream</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsForStreamResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListTagsForStreamResponse.Builder, ListTagsForStreamResponse> {
    private final List<Tag> tags;

    private final Boolean hasMoreTags;

    private ListTagsForStreamResponse(BuilderImpl builder) {
        this.tags = builder.tags;
        this.hasMoreTags = builder.hasMoreTags;
    }

    /**
     * <p>
     * A list of tags associated with <code>StreamName</code>, starting with the first tag after
     * <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of tags associated with <code>StreamName</code>, starting with the first tag after
     *         <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * If set to <code>true</code>, more tags are available. To request additional tags, set
     * <code>ExclusiveStartTagKey</code> to the key of the last tag returned.
     * </p>
     * 
     * @return If set to <code>true</code>, more tags are available. To request additional tags, set
     *         <code>ExclusiveStartTagKey</code> to the key of the last tag returned.
     */
    public Boolean hasMoreTags() {
        return hasMoreTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((hasMoreTags() == null) ? 0 : hasMoreTags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamResponse)) {
            return false;
        }
        ListTagsForStreamResponse other = (ListTagsForStreamResponse) obj;
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.hasMoreTags() == null ^ this.hasMoreTags() == null) {
            return false;
        }
        if (other.hasMoreTags() != null && !other.hasMoreTags().equals(this.hasMoreTags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (hasMoreTags() != null) {
            sb.append("HasMoreTags: ").append(hasMoreTags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        case "HasMoreTags":
            return Optional.of(clazz.cast(hasMoreTags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListTagsForStreamResponse> {
        /**
         * <p>
         * A list of tags associated with <code>StreamName</code>, starting with the first tag after
         * <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with <code>StreamName</code>, starting with the first tag after
         *        <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags associated with <code>StreamName</code>, starting with the first tag after
         * <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with <code>StreamName</code>, starting with the first tag after
         *        <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * If set to <code>true</code>, more tags are available. To request additional tags, set
         * <code>ExclusiveStartTagKey</code> to the key of the last tag returned.
         * </p>
         * 
         * @param hasMoreTags
         *        If set to <code>true</code>, more tags are available. To request additional tags, set
         *        <code>ExclusiveStartTagKey</code> to the key of the last tag returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreTags(Boolean hasMoreTags);
    }

    static final class BuilderImpl implements Builder {
        private List<Tag> tags;

        private Boolean hasMoreTags;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForStreamResponse model) {
            tags(model.tags);
            hasMoreTags(model.hasMoreTags);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getHasMoreTags() {
            return hasMoreTags;
        }

        @Override
        public final Builder hasMoreTags(Boolean hasMoreTags) {
            this.hasMoreTags = hasMoreTags;
            return this;
        }

        public final void setHasMoreTags(Boolean hasMoreTags) {
            this.hasMoreTags = hasMoreTags;
        }

        @Override
        public ListTagsForStreamResponse build() {
            return new ListTagsForStreamResponse(this);
        }
    }
}
