/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.transform.PutRecordsResultEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of an individual record from a <code>PutRecords</code> request. A record that is successfully
 * added to a stream includes <code>SequenceNumber</code> and <code>ShardId</code> in the result. A record that fails to
 * be added to the stream includes <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PutRecordsResultEntry implements StructuredPojo,
        ToCopyableBuilder<PutRecordsResultEntry.Builder, PutRecordsResultEntry> {
    private final String sequenceNumber;

    private final String shardId;

    private final String errorCode;

    private final String errorMessage;

    private PutRecordsResultEntry(BuilderImpl builder) {
        this.sequenceNumber = builder.sequenceNumber;
        this.shardId = builder.shardId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The sequence number for an individual record result.
     * </p>
     * 
     * @return The sequence number for an individual record result.
     */
    public String sequenceNumber() {
        return sequenceNumber;
    }

    /**
     * <p>
     * The shard ID for an individual record result.
     * </p>
     * 
     * @return The shard ID for an individual record result.
     */
    public String shardId() {
        return shardId;
    }

    /**
     * <p>
     * The error code for an individual record result. <code>ErrorCodes</code> can be either
     * <code>ProvisionedThroughputExceededException</code> or <code>InternalFailure</code>.
     * </p>
     * 
     * @return The error code for an individual record result. <code>ErrorCodes</code> can be either
     *         <code>ProvisionedThroughputExceededException</code> or <code>InternalFailure</code>.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message for an individual record result. An <code>ErrorCode</code> value of
     * <code>ProvisionedThroughputExceededException</code> has an error message that includes the account ID, stream
     * name, and shard ID. An <code>ErrorCode</code> value of <code>InternalFailure</code> has the error message
     * <code>"Internal Service Failure"</code>.
     * </p>
     * 
     * @return The error message for an individual record result. An <code>ErrorCode</code> value of
     *         <code>ProvisionedThroughputExceededException</code> has an error message that includes the account ID,
     *         stream name, and shard ID. An <code>ErrorCode</code> value of <code>InternalFailure</code> has the error
     *         message <code>"Internal Service Failure"</code>.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((sequenceNumber() == null) ? 0 : sequenceNumber().hashCode());
        hashCode = 31 * hashCode + ((shardId() == null) ? 0 : shardId().hashCode());
        hashCode = 31 * hashCode + ((errorCode() == null) ? 0 : errorCode().hashCode());
        hashCode = 31 * hashCode + ((errorMessage() == null) ? 0 : errorMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsResultEntry)) {
            return false;
        }
        PutRecordsResultEntry other = (PutRecordsResultEntry) obj;
        if (other.sequenceNumber() == null ^ this.sequenceNumber() == null) {
            return false;
        }
        if (other.sequenceNumber() != null && !other.sequenceNumber().equals(this.sequenceNumber())) {
            return false;
        }
        if (other.shardId() == null ^ this.shardId() == null) {
            return false;
        }
        if (other.shardId() != null && !other.shardId().equals(this.shardId())) {
            return false;
        }
        if (other.errorCode() == null ^ this.errorCode() == null) {
            return false;
        }
        if (other.errorCode() != null && !other.errorCode().equals(this.errorCode())) {
            return false;
        }
        if (other.errorMessage() == null ^ this.errorMessage() == null) {
            return false;
        }
        if (other.errorMessage() != null && !other.errorMessage().equals(this.errorMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (sequenceNumber() != null) {
            sb.append("SequenceNumber: ").append(sequenceNumber()).append(",");
        }
        if (shardId() != null) {
            sb.append("ShardId: ").append(shardId()).append(",");
        }
        if (errorCode() != null) {
            sb.append("ErrorCode: ").append(errorCode()).append(",");
        }
        if (errorMessage() != null) {
            sb.append("ErrorMessage: ").append(errorMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SequenceNumber":
            return Optional.of(clazz.cast(sequenceNumber()));
        case "ShardId":
            return Optional.of(clazz.cast(shardId()));
        case "ErrorCode":
            return Optional.of(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.of(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PutRecordsResultEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PutRecordsResultEntry> {
        /**
         * <p>
         * The sequence number for an individual record result.
         * </p>
         * 
         * @param sequenceNumber
         *        The sequence number for an individual record result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(String sequenceNumber);

        /**
         * <p>
         * The shard ID for an individual record result.
         * </p>
         * 
         * @param shardId
         *        The shard ID for an individual record result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * <p>
         * The error code for an individual record result. <code>ErrorCodes</code> can be either
         * <code>ProvisionedThroughputExceededException</code> or <code>InternalFailure</code>.
         * </p>
         * 
         * @param errorCode
         *        The error code for an individual record result. <code>ErrorCodes</code> can be either
         *        <code>ProvisionedThroughputExceededException</code> or <code>InternalFailure</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error message for an individual record result. An <code>ErrorCode</code> value of
         * <code>ProvisionedThroughputExceededException</code> has an error message that includes the account ID, stream
         * name, and shard ID. An <code>ErrorCode</code> value of <code>InternalFailure</code> has the error message
         * <code>"Internal Service Failure"</code>.
         * </p>
         * 
         * @param errorMessage
         *        The error message for an individual record result. An <code>ErrorCode</code> value of
         *        <code>ProvisionedThroughputExceededException</code> has an error message that includes the account ID,
         *        stream name, and shard ID. An <code>ErrorCode</code> value of <code>InternalFailure</code> has the
         *        error message <code>"Internal Service Failure"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String sequenceNumber;

        private String shardId;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsResultEntry model) {
            sequenceNumber(model.sequenceNumber);
            shardId(model.shardId);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getSequenceNumber() {
            return sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final String getShardId() {
            return shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public PutRecordsResultEntry build() {
            return new PutRecordsResultEntry(this);
        }
    }
}
