/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.CloudWatchLoggingOptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a description of CloudWatch logging options, including the log stream ARN and the role ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CloudWatchLoggingOption implements StructuredPojo,
        ToCopyableBuilder<CloudWatchLoggingOption.Builder, CloudWatchLoggingOption> {
    private final String logStreamARN;

    private final String roleARN;

    private CloudWatchLoggingOption(BuilderImpl builder) {
        this.logStreamARN = builder.logStreamARN;
        this.roleARN = builder.roleARN;
    }

    /**
     * <p>
     * ARN of the CloudWatch log to receive application messages.
     * </p>
     * 
     * @return ARN of the CloudWatch log to receive application messages.
     */
    public String logStreamARN() {
        return logStreamARN;
    }

    /**
     * <p>
     * IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the
     * IAM role used must have the <code>PutLogEvents</code> policy action enabled.
     * </p>
     * 
     * @return IAM ARN of the role to use to send application messages. Note: To write application messages to
     *         CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.
     */
    public String roleARN() {
        return roleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logStreamARN() == null) ? 0 : logStreamARN().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingOption)) {
            return false;
        }
        CloudWatchLoggingOption other = (CloudWatchLoggingOption) obj;
        if (other.logStreamARN() == null ^ this.logStreamARN() == null) {
            return false;
        }
        if (other.logStreamARN() != null && !other.logStreamARN().equals(this.logStreamARN())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (logStreamARN() != null) {
            sb.append("LogStreamARN: ").append(logStreamARN()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogStreamARN":
            return Optional.of(clazz.cast(logStreamARN()));
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchLoggingOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CloudWatchLoggingOption> {
        /**
         * <p>
         * ARN of the CloudWatch log to receive application messages.
         * </p>
         * 
         * @param logStreamARN
         *        ARN of the CloudWatch log to receive application messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamARN(String logStreamARN);

        /**
         * <p>
         * IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch,
         * the IAM role used must have the <code>PutLogEvents</code> policy action enabled.
         * </p>
         * 
         * @param roleARN
         *        IAM ARN of the role to use to send application messages. Note: To write application messages to
         *        CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);
    }

    static final class BuilderImpl implements Builder {
        private String logStreamARN;

        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingOption model) {
            logStreamARN(model.logStreamARN);
            roleARN(model.roleARN);
        }

        public final String getLogStreamARN() {
            return logStreamARN;
        }

        @Override
        public final Builder logStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
            return this;
        }

        public final void setLogStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public CloudWatchLoggingOption build() {
            return new CloudWatchLoggingOption(this);
        }
    }
}
