/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * TBD
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateApplicationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateApplicationResponse.Builder, CreateApplicationResponse> {
    private final ApplicationSummary applicationSummary;

    private CreateApplicationResponse(BuilderImpl builder) {
        this.applicationSummary = builder.applicationSummary;
    }

    /**
     * <p>
     * In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a response with a
     * summary of the application it created, including the application Amazon Resource Name (ARN), name, and status.
     * </p>
     * 
     * @return In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a response
     *         with a summary of the application it created, including the application Amazon Resource Name (ARN), name,
     *         and status.
     */
    public ApplicationSummary applicationSummary() {
        return applicationSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationSummary() == null) ? 0 : applicationSummary().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationResponse)) {
            return false;
        }
        CreateApplicationResponse other = (CreateApplicationResponse) obj;
        if (other.applicationSummary() == null ^ this.applicationSummary() == null) {
            return false;
        }
        if (other.applicationSummary() != null && !other.applicationSummary().equals(this.applicationSummary())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (applicationSummary() != null) {
            sb.append("ApplicationSummary: ").append(applicationSummary()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationSummary":
            return Optional.of(clazz.cast(applicationSummary()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateApplicationResponse> {
        /**
         * <p>
         * In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a response with
         * a summary of the application it created, including the application Amazon Resource Name (ARN), name, and
         * status.
         * </p>
         * 
         * @param applicationSummary
         *        In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a
         *        response with a summary of the application it created, including the application Amazon Resource Name
         *        (ARN), name, and status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSummary(ApplicationSummary applicationSummary);
    }

    static final class BuilderImpl implements Builder {
        private ApplicationSummary applicationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationResponse model) {
            applicationSummary(model.applicationSummary);
        }

        public final ApplicationSummary.Builder getApplicationSummary() {
            return applicationSummary != null ? applicationSummary.toBuilder() : null;
        }

        @Override
        public final Builder applicationSummary(ApplicationSummary applicationSummary) {
            this.applicationSummary = applicationSummary;
            return this;
        }

        public final void setApplicationSummary(ApplicationSummary.BuilderImpl applicationSummary) {
            this.applicationSummary = applicationSummary != null ? applicationSummary.build() : null;
        }

        @Override
        public CreateApplicationResponse build() {
            return new CreateApplicationResponse(this);
        }
    }
}
