/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteApplicationCloudWatchLoggingOptionRequest extends AmazonWebServiceRequest
        implements
        ToCopyableBuilder<DeleteApplicationCloudWatchLoggingOptionRequest.Builder, DeleteApplicationCloudWatchLoggingOptionRequest> {
    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final String cloudWatchLoggingOptionId;

    private DeleteApplicationCloudWatchLoggingOptionRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.cloudWatchLoggingOptionId = builder.cloudWatchLoggingOptionId;
    }

    /**
     * <p>
     * The Amazon Kinesis Analytics application name.
     * </p>
     * 
     * @return The Amazon Kinesis Analytics application name.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The version ID of the Amazon Kinesis Analytics application.
     * </p>
     * 
     * @return The version ID of the Amazon Kinesis Analytics application.
     */
    public Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to delete. You can use the
     * <a>DescribeApplication</a> operation to get the <code>CloudWatchLoggingOptionId</code>.
     * </p>
     * 
     * @return The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to delete. You can use the
     *         <a>DescribeApplication</a> operation to get the <code>CloudWatchLoggingOptionId</code>.
     */
    public String cloudWatchLoggingOptionId() {
        return cloudWatchLoggingOptionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((currentApplicationVersionId() == null) ? 0 : currentApplicationVersionId().hashCode());
        hashCode = 31 * hashCode + ((cloudWatchLoggingOptionId() == null) ? 0 : cloudWatchLoggingOptionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationCloudWatchLoggingOptionRequest)) {
            return false;
        }
        DeleteApplicationCloudWatchLoggingOptionRequest other = (DeleteApplicationCloudWatchLoggingOptionRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.currentApplicationVersionId() == null ^ this.currentApplicationVersionId() == null) {
            return false;
        }
        if (other.currentApplicationVersionId() != null
                && !other.currentApplicationVersionId().equals(this.currentApplicationVersionId())) {
            return false;
        }
        if (other.cloudWatchLoggingOptionId() == null ^ this.cloudWatchLoggingOptionId() == null) {
            return false;
        }
        if (other.cloudWatchLoggingOptionId() != null
                && !other.cloudWatchLoggingOptionId().equals(this.cloudWatchLoggingOptionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(currentApplicationVersionId()).append(",");
        }
        if (cloudWatchLoggingOptionId() != null) {
            sb.append("CloudWatchLoggingOptionId: ").append(cloudWatchLoggingOptionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.of(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.of(clazz.cast(currentApplicationVersionId()));
        case "CloudWatchLoggingOptionId":
            return Optional.of(clazz.cast(cloudWatchLoggingOptionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteApplicationCloudWatchLoggingOptionRequest> {
        /**
         * <p>
         * The Amazon Kinesis Analytics application name.
         * </p>
         * 
         * @param applicationName
         *        The Amazon Kinesis Analytics application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The version ID of the Amazon Kinesis Analytics application.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        The version ID of the Amazon Kinesis Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to delete. You can use the
         * <a>DescribeApplication</a> operation to get the <code>CloudWatchLoggingOptionId</code>.
         * </p>
         * 
         * @param cloudWatchLoggingOptionId
         *        The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to delete. You can use the
         *        <a>DescribeApplication</a> operation to get the <code>CloudWatchLoggingOptionId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId);
    }

    static final class BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private String cloudWatchLoggingOptionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationCloudWatchLoggingOptionRequest model) {
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            cloudWatchLoggingOptionId(model.cloudWatchLoggingOptionId);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final String getCloudWatchLoggingOptionId() {
            return cloudWatchLoggingOptionId;
        }

        @Override
        public final Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
            return this;
        }

        public final void setCloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
        }

        @Override
        public DeleteApplicationCloudWatchLoggingOptionRequest build() {
            return new DeleteApplicationCloudWatchLoggingOptionRequest(this);
        }
    }
}
