/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.MappingParametersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When configuring application input at the time of creating or updating an application, provides additional mapping
 * information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the
 * streaming source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MappingParameters implements StructuredPojo, ToCopyableBuilder<MappingParameters.Builder, MappingParameters> {
    private final JSONMappingParameters jsonMappingParameters;

    private final CSVMappingParameters csvMappingParameters;

    private MappingParameters(BuilderImpl builder) {
        this.jsonMappingParameters = builder.jsonMappingParameters;
        this.csvMappingParameters = builder.csvMappingParameters;
    }

    /**
     * <p>
     * Provides additional mapping information when JSON is the record format on the streaming source.
     * </p>
     * 
     * @return Provides additional mapping information when JSON is the record format on the streaming source.
     */
    public JSONMappingParameters jsonMappingParameters() {
        return jsonMappingParameters;
    }

    /**
     * <p>
     * Provides additional mapping information when the record format uses delimiters (for example, CSV).
     * </p>
     * 
     * @return Provides additional mapping information when the record format uses delimiters (for example, CSV).
     */
    public CSVMappingParameters csvMappingParameters() {
        return csvMappingParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jsonMappingParameters() == null) ? 0 : jsonMappingParameters().hashCode());
        hashCode = 31 * hashCode + ((csvMappingParameters() == null) ? 0 : csvMappingParameters().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingParameters)) {
            return false;
        }
        MappingParameters other = (MappingParameters) obj;
        if (other.jsonMappingParameters() == null ^ this.jsonMappingParameters() == null) {
            return false;
        }
        if (other.jsonMappingParameters() != null && !other.jsonMappingParameters().equals(this.jsonMappingParameters())) {
            return false;
        }
        if (other.csvMappingParameters() == null ^ this.csvMappingParameters() == null) {
            return false;
        }
        if (other.csvMappingParameters() != null && !other.csvMappingParameters().equals(this.csvMappingParameters())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jsonMappingParameters() != null) {
            sb.append("JSONMappingParameters: ").append(jsonMappingParameters()).append(",");
        }
        if (csvMappingParameters() != null) {
            sb.append("CSVMappingParameters: ").append(csvMappingParameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JSONMappingParameters":
            return Optional.of(clazz.cast(jsonMappingParameters()));
        case "CSVMappingParameters":
            return Optional.of(clazz.cast(csvMappingParameters()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MappingParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MappingParameters> {
        /**
         * <p>
         * Provides additional mapping information when JSON is the record format on the streaming source.
         * </p>
         * 
         * @param jsonMappingParameters
         *        Provides additional mapping information when JSON is the record format on the streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonMappingParameters(JSONMappingParameters jsonMappingParameters);

        /**
         * <p>
         * Provides additional mapping information when the record format uses delimiters (for example, CSV).
         * </p>
         * 
         * @param csvMappingParameters
         *        Provides additional mapping information when the record format uses delimiters (for example, CSV).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvMappingParameters(CSVMappingParameters csvMappingParameters);
    }

    static final class BuilderImpl implements Builder {
        private JSONMappingParameters jsonMappingParameters;

        private CSVMappingParameters csvMappingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(MappingParameters model) {
            jsonMappingParameters(model.jsonMappingParameters);
            csvMappingParameters(model.csvMappingParameters);
        }

        public final JSONMappingParameters.Builder getJSONMappingParameters() {
            return jsonMappingParameters != null ? jsonMappingParameters.toBuilder() : null;
        }

        @Override
        public final Builder jsonMappingParameters(JSONMappingParameters jsonMappingParameters) {
            this.jsonMappingParameters = jsonMappingParameters;
            return this;
        }

        public final void setJSONMappingParameters(JSONMappingParameters.BuilderImpl jsonMappingParameters) {
            this.jsonMappingParameters = jsonMappingParameters != null ? jsonMappingParameters.build() : null;
        }

        public final CSVMappingParameters.Builder getCSVMappingParameters() {
            return csvMappingParameters != null ? csvMappingParameters.toBuilder() : null;
        }

        @Override
        public final Builder csvMappingParameters(CSVMappingParameters csvMappingParameters) {
            this.csvMappingParameters = csvMappingParameters;
            return this;
        }

        public final void setCSVMappingParameters(CSVMappingParameters.BuilderImpl csvMappingParameters) {
            this.csvMappingParameters = csvMappingParameters != null ? csvMappingParameters.build() : null;
        }

        @Override
        public MappingParameters build() {
            return new MappingParameters(this);
        }
    }
}
