/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.RecordColumnMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the mapping of each data element in the streaming source to the corresponding column in the in-application
 * stream.
 * </p>
 * <p>
 * Also used to describe the format of the reference data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RecordColumn implements StructuredPojo, ToCopyableBuilder<RecordColumn.Builder, RecordColumn> {
    private final String name;

    private final String mapping;

    private final String sqlType;

    private RecordColumn(BuilderImpl builder) {
        this.name = builder.name;
        this.mapping = builder.mapping;
        this.sqlType = builder.sqlType;
    }

    /**
     * <p>
     * Name of the column created in the in-application input stream or reference table.
     * </p>
     * 
     * @return Name of the column created in the in-application input stream or reference table.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Reference to the data element in the streaming input of the reference data source.
     * </p>
     * 
     * @return Reference to the data element in the streaming input of the reference data source.
     */
    public String mapping() {
        return mapping;
    }

    /**
     * <p>
     * Type of column created in the in-application input stream or reference table.
     * </p>
     * 
     * @return Type of column created in the in-application input stream or reference table.
     */
    public String sqlType() {
        return sqlType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((mapping() == null) ? 0 : mapping().hashCode());
        hashCode = 31 * hashCode + ((sqlType() == null) ? 0 : sqlType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordColumn)) {
            return false;
        }
        RecordColumn other = (RecordColumn) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.mapping() == null ^ this.mapping() == null) {
            return false;
        }
        if (other.mapping() != null && !other.mapping().equals(this.mapping())) {
            return false;
        }
        if (other.sqlType() == null ^ this.sqlType() == null) {
            return false;
        }
        if (other.sqlType() != null && !other.sqlType().equals(this.sqlType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (mapping() != null) {
            sb.append("Mapping: ").append(mapping()).append(",");
        }
        if (sqlType() != null) {
            sb.append("SqlType: ").append(sqlType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Mapping":
            return Optional.of(clazz.cast(mapping()));
        case "SqlType":
            return Optional.of(clazz.cast(sqlType()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordColumnMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RecordColumn> {
        /**
         * <p>
         * Name of the column created in the in-application input stream or reference table.
         * </p>
         * 
         * @param name
         *        Name of the column created in the in-application input stream or reference table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Reference to the data element in the streaming input of the reference data source.
         * </p>
         * 
         * @param mapping
         *        Reference to the data element in the streaming input of the reference data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapping(String mapping);

        /**
         * <p>
         * Type of column created in the in-application input stream or reference table.
         * </p>
         * 
         * @param sqlType
         *        Type of column created in the in-application input stream or reference table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlType(String sqlType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String mapping;

        private String sqlType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordColumn model) {
            name(model.name);
            mapping(model.mapping);
            sqlType(model.sqlType);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMapping() {
            return mapping;
        }

        @Override
        public final Builder mapping(String mapping) {
            this.mapping = mapping;
            return this;
        }

        public final void setMapping(String mapping) {
            this.mapping = mapping;
        }

        public final String getSqlType() {
            return sqlType;
        }

        @Override
        public final Builder sqlType(String sqlType) {
            this.sqlType = sqlType;
            return this;
        }

        public final void setSqlType(String sqlType) {
            this.sqlType = sqlType;
        }

        @Override
        public RecordColumn build() {
            return new RecordColumn(this);
        }
    }
}
