/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.ReferenceDataSourceDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the reference data source configured for an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReferenceDataSourceDescription implements StructuredPojo,
        ToCopyableBuilder<ReferenceDataSourceDescription.Builder, ReferenceDataSourceDescription> {
    private final String referenceId;

    private final String tableName;

    private final S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription;

    private final SourceSchema referenceSchema;

    private ReferenceDataSourceDescription(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.tableName = builder.tableName;
        this.s3ReferenceDataSourceDescription = builder.s3ReferenceDataSourceDescription;
        this.referenceSchema = builder.referenceSchema;
    }

    /**
     * <p>
     * ID of the reference data source. This is the ID that Amazon Kinesis Analytics assigns when you add the reference
     * data source to your application using the <a>AddApplicationReferenceDataSource</a> operation.
     * </p>
     * 
     * @return ID of the reference data source. This is the ID that Amazon Kinesis Analytics assigns when you add the
     *         reference data source to your application using the <a>AddApplicationReferenceDataSource</a> operation.
     */
    public String referenceId() {
        return referenceId;
    }

    /**
     * <p>
     * The in-application table name created by the specific reference data source configuration.
     * </p>
     * 
     * @return The in-application table name created by the specific reference data source configuration.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Provides the S3 bucket name, the object key name that contains the reference data. It also provides the Amazon
     * Resource Name (ARN) of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and
     * populate the in-application reference table.
     * </p>
     * 
     * @return Provides the S3 bucket name, the object key name that contains the reference data. It also provides the
     *         Amazon Resource Name (ARN) of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3
     *         object and populate the in-application reference table.
     */
    public S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription() {
        return s3ReferenceDataSourceDescription;
    }

    /**
     * Returns the value of the ReferenceSchema property for this object.
     * 
     * @return The value of the ReferenceSchema property for this object.
     */
    public SourceSchema referenceSchema() {
        return referenceSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((referenceId() == null) ? 0 : referenceId().hashCode());
        hashCode = 31 * hashCode + ((tableName() == null) ? 0 : tableName().hashCode());
        hashCode = 31 * hashCode
                + ((s3ReferenceDataSourceDescription() == null) ? 0 : s3ReferenceDataSourceDescription().hashCode());
        hashCode = 31 * hashCode + ((referenceSchema() == null) ? 0 : referenceSchema().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSourceDescription)) {
            return false;
        }
        ReferenceDataSourceDescription other = (ReferenceDataSourceDescription) obj;
        if (other.referenceId() == null ^ this.referenceId() == null) {
            return false;
        }
        if (other.referenceId() != null && !other.referenceId().equals(this.referenceId())) {
            return false;
        }
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.s3ReferenceDataSourceDescription() == null ^ this.s3ReferenceDataSourceDescription() == null) {
            return false;
        }
        if (other.s3ReferenceDataSourceDescription() != null
                && !other.s3ReferenceDataSourceDescription().equals(this.s3ReferenceDataSourceDescription())) {
            return false;
        }
        if (other.referenceSchema() == null ^ this.referenceSchema() == null) {
            return false;
        }
        if (other.referenceSchema() != null && !other.referenceSchema().equals(this.referenceSchema())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (referenceId() != null) {
            sb.append("ReferenceId: ").append(referenceId()).append(",");
        }
        if (tableName() != null) {
            sb.append("TableName: ").append(tableName()).append(",");
        }
        if (s3ReferenceDataSourceDescription() != null) {
            sb.append("S3ReferenceDataSourceDescription: ").append(s3ReferenceDataSourceDescription()).append(",");
        }
        if (referenceSchema() != null) {
            sb.append("ReferenceSchema: ").append(referenceSchema()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReferenceId":
            return Optional.of(clazz.cast(referenceId()));
        case "TableName":
            return Optional.of(clazz.cast(tableName()));
        case "S3ReferenceDataSourceDescription":
            return Optional.of(clazz.cast(s3ReferenceDataSourceDescription()));
        case "ReferenceSchema":
            return Optional.of(clazz.cast(referenceSchema()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReferenceDataSourceDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ReferenceDataSourceDescription> {
        /**
         * <p>
         * ID of the reference data source. This is the ID that Amazon Kinesis Analytics assigns when you add the
         * reference data source to your application using the <a>AddApplicationReferenceDataSource</a> operation.
         * </p>
         * 
         * @param referenceId
         *        ID of the reference data source. This is the ID that Amazon Kinesis Analytics assigns when you add the
         *        reference data source to your application using the <a>AddApplicationReferenceDataSource</a>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(String referenceId);

        /**
         * <p>
         * The in-application table name created by the specific reference data source configuration.
         * </p>
         * 
         * @param tableName
         *        The in-application table name created by the specific reference data source configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Provides the S3 bucket name, the object key name that contains the reference data. It also provides the
         * Amazon Resource Name (ARN) of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3
         * object and populate the in-application reference table.
         * </p>
         * 
         * @param s3ReferenceDataSourceDescription
         *        Provides the S3 bucket name, the object key name that contains the reference data. It also provides
         *        the Amazon Resource Name (ARN) of the IAM role that Amazon Kinesis Analytics can assume to read the
         *        Amazon S3 object and populate the in-application reference table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ReferenceDataSourceDescription(S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription);

        /**
         * Sets the value of the ReferenceSchema property for this object.
         *
         * @param referenceSchema
         *        The new value for the ReferenceSchema property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceSchema(SourceSchema referenceSchema);
    }

    static final class BuilderImpl implements Builder {
        private String referenceId;

        private String tableName;

        private S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription;

        private SourceSchema referenceSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSourceDescription model) {
            referenceId(model.referenceId);
            tableName(model.tableName);
            s3ReferenceDataSourceDescription(model.s3ReferenceDataSourceDescription);
            referenceSchema(model.referenceSchema);
        }

        public final String getReferenceId() {
            return referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final S3ReferenceDataSourceDescription.Builder getS3ReferenceDataSourceDescription() {
            return s3ReferenceDataSourceDescription != null ? s3ReferenceDataSourceDescription.toBuilder() : null;
        }

        @Override
        public final Builder s3ReferenceDataSourceDescription(S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription) {
            this.s3ReferenceDataSourceDescription = s3ReferenceDataSourceDescription;
            return this;
        }

        public final void setS3ReferenceDataSourceDescription(
                S3ReferenceDataSourceDescription.BuilderImpl s3ReferenceDataSourceDescription) {
            this.s3ReferenceDataSourceDescription = s3ReferenceDataSourceDescription != null ? s3ReferenceDataSourceDescription
                    .build() : null;
        }

        public final SourceSchema.Builder getReferenceSchema() {
            return referenceSchema != null ? referenceSchema.toBuilder() : null;
        }

        @Override
        public final Builder referenceSchema(SourceSchema referenceSchema) {
            this.referenceSchema = referenceSchema;
            return this;
        }

        public final void setReferenceSchema(SourceSchema.BuilderImpl referenceSchema) {
            this.referenceSchema = referenceSchema != null ? referenceSchema.build() : null;
        }

        @Override
        public ReferenceDataSourceDescription build() {
            return new ReferenceDataSourceDescription(this);
        }
    }
}
