/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.Processor;
import software.amazon.awssdk.services.firehose.model.ProcessorListCopier;
import software.amazon.awssdk.services.firehose.transform.ProcessingConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProcessingConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ProcessingConfiguration> {
    private final Boolean enabled;
    private final List<Processor> processors;

    private ProcessingConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.processors = builder.processors;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public List<Processor> processors() {
        return this.processors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.processors() == null ? 0 : this.processors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingConfiguration)) {
            return false;
        }
        ProcessingConfiguration other = (ProcessingConfiguration)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.processors() == null ^ this.processors() == null) {
            return false;
        }
        return other.processors() == null || other.processors().equals(this.processors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.processors() != null) {
            sb.append("Processors: ").append(this.processors()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "Processors": {
                return Optional.of(clazz.cast(this.processors()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProcessingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private List<Processor> processors;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingConfiguration model) {
            this.enabled(model.enabled);
            this.processors(model.processors);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<Processor.Builder> getProcessors() {
            return this.processors != null ? (Collection)this.processors.stream().map(Processor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processors(Collection<Processor> processors) {
            this.processors = ProcessorListCopier.copy(processors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Processor ... processors) {
            this.processors(Arrays.asList(processors));
            return this;
        }

        public final void setProcessors(Collection<Processor.BuilderImpl> processors) {
            this.processors = ProcessorListCopier.copyFromBuilder(processors);
        }

        public ProcessingConfiguration build() {
            return new ProcessingConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProcessingConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder processors(Collection<Processor> var1);

        public Builder processors(Processor ... var1);
    }
}

