/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.firehose.model.Record;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutRecordRequest> {
    private final String deliveryStreamName;
    private final Record record;

    private PutRecordRequest(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.record = builder.record;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public Record record() {
        return this.record;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deliveryStreamName() == null ? 0 : this.deliveryStreamName().hashCode());
        hashCode = 31 * hashCode + (this.record() == null ? 0 : this.record().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordRequest)) {
            return false;
        }
        PutRecordRequest other = (PutRecordRequest)((Object)obj);
        if (other.deliveryStreamName() == null ^ this.deliveryStreamName() == null) {
            return false;
        }
        if (other.deliveryStreamName() != null && !other.deliveryStreamName().equals(this.deliveryStreamName())) {
            return false;
        }
        if (other.record() == null ^ this.record() == null) {
            return false;
        }
        return other.record() == null || other.record().equals(this.record());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(this.deliveryStreamName()).append(",");
        }
        if (this.record() != null) {
            sb.append("Record: ").append(this.record()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamName": {
                return Optional.of(clazz.cast(this.deliveryStreamName()));
            }
            case "Record": {
                return Optional.of(clazz.cast(this.record()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private Record record;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordRequest model) {
            this.deliveryStreamName(model.deliveryStreamName);
            this.record(model.record);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final Record.Builder getRecord() {
            return this.record != null ? this.record.toBuilder() : null;
        }

        @Override
        public final Builder record(Record record) {
            this.record = record;
            return this;
        }

        public final void setRecord(Record.BuilderImpl record) {
            this.record = record != null ? record.build() : null;
        }

        public PutRecordRequest build() {
            return new PutRecordRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRecordRequest> {
        public Builder deliveryStreamName(String var1);

        public Builder record(Record var1);
    }
}

