/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.kinesis.model.MetricsName;
import software.amazon.awssdk.services.kinesis.model.MetricsNameListCopier;
import software.amazon.awssdk.services.kinesis.transform.EnhancedMetricsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnhancedMetrics
implements StructuredPojo,
ToCopyableBuilder<Builder, EnhancedMetrics> {
    private final List<String> shardLevelMetrics;

    private EnhancedMetrics(BuilderImpl builder) {
        this.shardLevelMetrics = builder.shardLevelMetrics;
    }

    public List<MetricsName> shardLevelMetrics() {
        return TypeConverter.convert(this.shardLevelMetrics, MetricsName::fromValue);
    }

    public List<String> shardLevelMetricsStrings() {
        return this.shardLevelMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.shardLevelMetricsStrings() == null ? 0 : this.shardLevelMetricsStrings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnhancedMetrics)) {
            return false;
        }
        EnhancedMetrics other = (EnhancedMetrics)obj;
        if (other.shardLevelMetricsStrings() == null ^ this.shardLevelMetricsStrings() == null) {
            return false;
        }
        return other.shardLevelMetricsStrings() == null || other.shardLevelMetricsStrings().equals(this.shardLevelMetricsStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.shardLevelMetricsStrings() != null) {
            sb.append("ShardLevelMetrics: ").append(this.shardLevelMetricsStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShardLevelMetrics": {
                return Optional.of(clazz.cast(this.shardLevelMetricsStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnhancedMetricsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> shardLevelMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(EnhancedMetrics model) {
            this.shardLevelMetrics(model.shardLevelMetrics);
        }

        public final Collection<String> getShardLevelMetrics() {
            return this.shardLevelMetrics;
        }

        @Override
        public final Builder shardLevelMetrics(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetrics(String ... shardLevelMetrics) {
            this.shardLevelMetrics(Arrays.asList(shardLevelMetrics));
            return this;
        }

        public final void setShardLevelMetrics(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
        }

        public EnhancedMetrics build() {
            return new EnhancedMetrics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnhancedMetrics> {
        public Builder shardLevelMetrics(Collection<String> var1);

        public Builder shardLevelMetrics(String ... var1);
    }
}

