/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.HashKeyRange;

@SdkInternalApi
public class HashKeyRangeMarshaller {
    private static final MarshallingInfo<String> STARTINGHASHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartingHashKey").build();
    private static final MarshallingInfo<String> ENDINGHASHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndingHashKey").build();
    private static final HashKeyRangeMarshaller INSTANCE = new HashKeyRangeMarshaller();

    public static HashKeyRangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HashKeyRange hashKeyRange, ProtocolMarshaller protocolMarshaller) {
        if (hashKeyRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)hashKeyRange.startingHashKey(), STARTINGHASHKEY_BINDING);
            protocolMarshaller.marshall((Object)hashKeyRange.endingHashKey(), ENDINGHASHKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

