/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.CSVMappingParameters;
import software.amazon.awssdk.services.kinesisanalytics.model.JSONMappingParameters;
import software.amazon.awssdk.services.kinesisanalytics.transform.MappingParametersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MappingParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, MappingParameters> {
    private final JSONMappingParameters jsonMappingParameters;
    private final CSVMappingParameters csvMappingParameters;

    private MappingParameters(BuilderImpl builder) {
        this.jsonMappingParameters = builder.jsonMappingParameters;
        this.csvMappingParameters = builder.csvMappingParameters;
    }

    public JSONMappingParameters jsonMappingParameters() {
        return this.jsonMappingParameters;
    }

    public CSVMappingParameters csvMappingParameters() {
        return this.csvMappingParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jsonMappingParameters() == null ? 0 : this.jsonMappingParameters().hashCode());
        hashCode = 31 * hashCode + (this.csvMappingParameters() == null ? 0 : this.csvMappingParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingParameters)) {
            return false;
        }
        MappingParameters other = (MappingParameters)obj;
        if (other.jsonMappingParameters() == null ^ this.jsonMappingParameters() == null) {
            return false;
        }
        if (other.jsonMappingParameters() != null && !other.jsonMappingParameters().equals(this.jsonMappingParameters())) {
            return false;
        }
        if (other.csvMappingParameters() == null ^ this.csvMappingParameters() == null) {
            return false;
        }
        return other.csvMappingParameters() == null || other.csvMappingParameters().equals(this.csvMappingParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jsonMappingParameters() != null) {
            sb.append("JSONMappingParameters: ").append(this.jsonMappingParameters()).append(",");
        }
        if (this.csvMappingParameters() != null) {
            sb.append("CSVMappingParameters: ").append(this.csvMappingParameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JSONMappingParameters": {
                return Optional.of(clazz.cast(this.jsonMappingParameters()));
            }
            case "CSVMappingParameters": {
                return Optional.of(clazz.cast(this.csvMappingParameters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MappingParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private JSONMappingParameters jsonMappingParameters;
        private CSVMappingParameters csvMappingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(MappingParameters model) {
            this.jsonMappingParameters(model.jsonMappingParameters);
            this.csvMappingParameters(model.csvMappingParameters);
        }

        public final JSONMappingParameters.Builder getJSONMappingParameters() {
            return this.jsonMappingParameters != null ? this.jsonMappingParameters.toBuilder() : null;
        }

        @Override
        public final Builder jsonMappingParameters(JSONMappingParameters jsonMappingParameters) {
            this.jsonMappingParameters = jsonMappingParameters;
            return this;
        }

        public final void setJSONMappingParameters(JSONMappingParameters.BuilderImpl jsonMappingParameters) {
            this.jsonMappingParameters = jsonMappingParameters != null ? jsonMappingParameters.build() : null;
        }

        public final CSVMappingParameters.Builder getCSVMappingParameters() {
            return this.csvMappingParameters != null ? this.csvMappingParameters.toBuilder() : null;
        }

        @Override
        public final Builder csvMappingParameters(CSVMappingParameters csvMappingParameters) {
            this.csvMappingParameters = csvMappingParameters;
            return this;
        }

        public final void setCSVMappingParameters(CSVMappingParameters.BuilderImpl csvMappingParameters) {
            this.csvMappingParameters = csvMappingParameters != null ? csvMappingParameters.build() : null;
        }

        public MappingParameters build() {
            return new MappingParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MappingParameters> {
        public Builder jsonMappingParameters(JSONMappingParameters var1);

        public Builder csvMappingParameters(CSVMappingParameters var1);
    }
}

