/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.DestinationSchema;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseOutputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.transform.OutputUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OutputUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, OutputUpdate> {
    private final String outputId;
    private final String nameUpdate;
    private final KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate;
    private final KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate;
    private final DestinationSchema destinationSchemaUpdate;

    private OutputUpdate(BuilderImpl builder) {
        this.outputId = builder.outputId;
        this.nameUpdate = builder.nameUpdate;
        this.kinesisStreamsOutputUpdate = builder.kinesisStreamsOutputUpdate;
        this.kinesisFirehoseOutputUpdate = builder.kinesisFirehoseOutputUpdate;
        this.destinationSchemaUpdate = builder.destinationSchemaUpdate;
    }

    public String outputId() {
        return this.outputId;
    }

    public String nameUpdate() {
        return this.nameUpdate;
    }

    public KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate() {
        return this.kinesisStreamsOutputUpdate;
    }

    public KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate() {
        return this.kinesisFirehoseOutputUpdate;
    }

    public DestinationSchema destinationSchemaUpdate() {
        return this.destinationSchemaUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.outputId() == null ? 0 : this.outputId().hashCode());
        hashCode = 31 * hashCode + (this.nameUpdate() == null ? 0 : this.nameUpdate().hashCode());
        hashCode = 31 * hashCode + (this.kinesisStreamsOutputUpdate() == null ? 0 : this.kinesisStreamsOutputUpdate().hashCode());
        hashCode = 31 * hashCode + (this.kinesisFirehoseOutputUpdate() == null ? 0 : this.kinesisFirehoseOutputUpdate().hashCode());
        hashCode = 31 * hashCode + (this.destinationSchemaUpdate() == null ? 0 : this.destinationSchemaUpdate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputUpdate)) {
            return false;
        }
        OutputUpdate other = (OutputUpdate)obj;
        if (other.outputId() == null ^ this.outputId() == null) {
            return false;
        }
        if (other.outputId() != null && !other.outputId().equals(this.outputId())) {
            return false;
        }
        if (other.nameUpdate() == null ^ this.nameUpdate() == null) {
            return false;
        }
        if (other.nameUpdate() != null && !other.nameUpdate().equals(this.nameUpdate())) {
            return false;
        }
        if (other.kinesisStreamsOutputUpdate() == null ^ this.kinesisStreamsOutputUpdate() == null) {
            return false;
        }
        if (other.kinesisStreamsOutputUpdate() != null && !other.kinesisStreamsOutputUpdate().equals(this.kinesisStreamsOutputUpdate())) {
            return false;
        }
        if (other.kinesisFirehoseOutputUpdate() == null ^ this.kinesisFirehoseOutputUpdate() == null) {
            return false;
        }
        if (other.kinesisFirehoseOutputUpdate() != null && !other.kinesisFirehoseOutputUpdate().equals(this.kinesisFirehoseOutputUpdate())) {
            return false;
        }
        if (other.destinationSchemaUpdate() == null ^ this.destinationSchemaUpdate() == null) {
            return false;
        }
        return other.destinationSchemaUpdate() == null || other.destinationSchemaUpdate().equals(this.destinationSchemaUpdate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.outputId() != null) {
            sb.append("OutputId: ").append(this.outputId()).append(",");
        }
        if (this.nameUpdate() != null) {
            sb.append("NameUpdate: ").append(this.nameUpdate()).append(",");
        }
        if (this.kinesisStreamsOutputUpdate() != null) {
            sb.append("KinesisStreamsOutputUpdate: ").append(this.kinesisStreamsOutputUpdate()).append(",");
        }
        if (this.kinesisFirehoseOutputUpdate() != null) {
            sb.append("KinesisFirehoseOutputUpdate: ").append(this.kinesisFirehoseOutputUpdate()).append(",");
        }
        if (this.destinationSchemaUpdate() != null) {
            sb.append("DestinationSchemaUpdate: ").append(this.destinationSchemaUpdate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputId": {
                return Optional.of(clazz.cast(this.outputId()));
            }
            case "NameUpdate": {
                return Optional.of(clazz.cast(this.nameUpdate()));
            }
            case "KinesisStreamsOutputUpdate": {
                return Optional.of(clazz.cast(this.kinesisStreamsOutputUpdate()));
            }
            case "KinesisFirehoseOutputUpdate": {
                return Optional.of(clazz.cast(this.kinesisFirehoseOutputUpdate()));
            }
            case "DestinationSchemaUpdate": {
                return Optional.of(clazz.cast(this.destinationSchemaUpdate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputId;
        private String nameUpdate;
        private KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate;
        private KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate;
        private DestinationSchema destinationSchemaUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputUpdate model) {
            this.outputId(model.outputId);
            this.nameUpdate(model.nameUpdate);
            this.kinesisStreamsOutputUpdate(model.kinesisStreamsOutputUpdate);
            this.kinesisFirehoseOutputUpdate(model.kinesisFirehoseOutputUpdate);
            this.destinationSchemaUpdate(model.destinationSchemaUpdate);
        }

        public final String getOutputId() {
            return this.outputId;
        }

        @Override
        public final Builder outputId(String outputId) {
            this.outputId = outputId;
            return this;
        }

        public final void setOutputId(String outputId) {
            this.outputId = outputId;
        }

        public final String getNameUpdate() {
            return this.nameUpdate;
        }

        @Override
        public final Builder nameUpdate(String nameUpdate) {
            this.nameUpdate = nameUpdate;
            return this;
        }

        public final void setNameUpdate(String nameUpdate) {
            this.nameUpdate = nameUpdate;
        }

        public final KinesisStreamsOutputUpdate.Builder getKinesisStreamsOutputUpdate() {
            return this.kinesisStreamsOutputUpdate != null ? this.kinesisStreamsOutputUpdate.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate) {
            this.kinesisStreamsOutputUpdate = kinesisStreamsOutputUpdate;
            return this;
        }

        public final void setKinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate.BuilderImpl kinesisStreamsOutputUpdate) {
            this.kinesisStreamsOutputUpdate = kinesisStreamsOutputUpdate != null ? kinesisStreamsOutputUpdate.build() : null;
        }

        public final KinesisFirehoseOutputUpdate.Builder getKinesisFirehoseOutputUpdate() {
            return this.kinesisFirehoseOutputUpdate != null ? this.kinesisFirehoseOutputUpdate.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate) {
            this.kinesisFirehoseOutputUpdate = kinesisFirehoseOutputUpdate;
            return this;
        }

        public final void setKinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate.BuilderImpl kinesisFirehoseOutputUpdate) {
            this.kinesisFirehoseOutputUpdate = kinesisFirehoseOutputUpdate != null ? kinesisFirehoseOutputUpdate.build() : null;
        }

        public final DestinationSchema.Builder getDestinationSchemaUpdate() {
            return this.destinationSchemaUpdate != null ? this.destinationSchemaUpdate.toBuilder() : null;
        }

        @Override
        public final Builder destinationSchemaUpdate(DestinationSchema destinationSchemaUpdate) {
            this.destinationSchemaUpdate = destinationSchemaUpdate;
            return this;
        }

        public final void setDestinationSchemaUpdate(DestinationSchema.BuilderImpl destinationSchemaUpdate) {
            this.destinationSchemaUpdate = destinationSchemaUpdate != null ? destinationSchemaUpdate.build() : null;
        }

        public OutputUpdate build() {
            return new OutputUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutputUpdate> {
        public Builder outputId(String var1);

        public Builder nameUpdate(String var1);

        public Builder kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate var1);

        public Builder kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate var1);

        public Builder destinationSchemaUpdate(DestinationSchema var1);
    }
}

