/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.RecordColumnMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecordColumn
implements StructuredPojo,
ToCopyableBuilder<Builder, RecordColumn> {
    private final String name;
    private final String mapping;
    private final String sqlType;

    private RecordColumn(BuilderImpl builder) {
        this.name = builder.name;
        this.mapping = builder.mapping;
        this.sqlType = builder.sqlType;
    }

    public String name() {
        return this.name;
    }

    public String mapping() {
        return this.mapping;
    }

    public String sqlType() {
        return this.sqlType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.mapping() == null ? 0 : this.mapping().hashCode());
        hashCode = 31 * hashCode + (this.sqlType() == null ? 0 : this.sqlType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordColumn)) {
            return false;
        }
        RecordColumn other = (RecordColumn)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.mapping() == null ^ this.mapping() == null) {
            return false;
        }
        if (other.mapping() != null && !other.mapping().equals(this.mapping())) {
            return false;
        }
        if (other.sqlType() == null ^ this.sqlType() == null) {
            return false;
        }
        return other.sqlType() == null || other.sqlType().equals(this.sqlType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.mapping() != null) {
            sb.append("Mapping: ").append(this.mapping()).append(",");
        }
        if (this.sqlType() != null) {
            sb.append("SqlType: ").append(this.sqlType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Mapping": {
                return Optional.of(clazz.cast(this.mapping()));
            }
            case "SqlType": {
                return Optional.of(clazz.cast(this.sqlType()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordColumnMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String mapping;
        private String sqlType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordColumn model) {
            this.name(model.name);
            this.mapping(model.mapping);
            this.sqlType(model.sqlType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMapping() {
            return this.mapping;
        }

        @Override
        public final Builder mapping(String mapping) {
            this.mapping = mapping;
            return this;
        }

        public final void setMapping(String mapping) {
            this.mapping = mapping;
        }

        public final String getSqlType() {
            return this.sqlType;
        }

        @Override
        public final Builder sqlType(String sqlType) {
            this.sqlType = sqlType;
            return this;
        }

        public final void setSqlType(String sqlType) {
            this.sqlType = sqlType;
        }

        public RecordColumn build() {
            return new RecordColumn(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecordColumn> {
        public Builder name(String var1);

        public Builder mapping(String var1);

        public Builder sqlType(String var1);
    }
}

