/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn;

@SdkInternalApi
public class RecordColumnMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> MAPPING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mapping").build();
    private static final MarshallingInfo<String> SQLTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SqlType").build();
    private static final RecordColumnMarshaller INSTANCE = new RecordColumnMarshaller();

    public static RecordColumnMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RecordColumn recordColumn, ProtocolMarshaller protocolMarshaller) {
        if (recordColumn == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)recordColumn.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)recordColumn.mapping(), MAPPING_BINDING);
            protocolMarshaller.marshall((Object)recordColumn.sqlType(), SQLTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

