/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDeliveryStreamResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeDeliveryStreamResponse.Builder, DescribeDeliveryStreamResponse> {
    private final DeliveryStreamDescription deliveryStreamDescription;

    private DescribeDeliveryStreamResponse(BuilderImpl builder) {
        this.deliveryStreamDescription = builder.deliveryStreamDescription;
    }

    /**
     * <p>
     * Information about the delivery stream.
     * </p>
     * 
     * @return Information about the delivery stream.
     */
    public DeliveryStreamDescription deliveryStreamDescription() {
        return deliveryStreamDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryStreamResponse)) {
            return false;
        }
        DescribeDeliveryStreamResponse other = (DescribeDeliveryStreamResponse) obj;
        return Objects.equals(deliveryStreamDescription(), other.deliveryStreamDescription());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deliveryStreamDescription() != null) {
            sb.append("DeliveryStreamDescription: ").append(deliveryStreamDescription()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamDescription":
            return Optional.of(clazz.cast(deliveryStreamDescription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeDeliveryStreamResponse> {
        /**
         * <p>
         * Information about the delivery stream.
         * </p>
         * 
         * @param deliveryStreamDescription
         *        Information about the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamDescription(DeliveryStreamDescription deliveryStreamDescription);

        /**
         * <p>
         * Information about the delivery stream.
         * </p>
         * This is a convenience that creates an instance of the {@link DeliveryStreamDescription.Builder} avoiding the
         * need to create one manually via {@link DeliveryStreamDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeliveryStreamDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #deliveryStreamDescription(DeliveryStreamDescription)}.
         * 
         * @param deliveryStreamDescription
         *        a consumer that will call methods on {@link DeliveryStreamDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliveryStreamDescription(DeliveryStreamDescription)
         */
        default Builder deliveryStreamDescription(Consumer<DeliveryStreamDescription.Builder> deliveryStreamDescription) {
            return deliveryStreamDescription(DeliveryStreamDescription.builder().apply(deliveryStreamDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DeliveryStreamDescription deliveryStreamDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryStreamResponse model) {
            deliveryStreamDescription(model.deliveryStreamDescription);
        }

        public final DeliveryStreamDescription.Builder getDeliveryStreamDescription() {
            return deliveryStreamDescription != null ? deliveryStreamDescription.toBuilder() : null;
        }

        @Override
        public final Builder deliveryStreamDescription(DeliveryStreamDescription deliveryStreamDescription) {
            this.deliveryStreamDescription = deliveryStreamDescription;
            return this;
        }

        public final void setDeliveryStreamDescription(DeliveryStreamDescription.BuilderImpl deliveryStreamDescription) {
            this.deliveryStreamDescription = deliveryStreamDescription != null ? deliveryStreamDescription.build() : null;
        }

        @Override
        public DescribeDeliveryStreamResponse build() {
            return new DescribeDeliveryStreamResponse(this);
        }
    }
}
