/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.ElasticsearchRetryOptionsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures retry behavior in case Kinesis Firehose is unable to deliver documents to Amazon ES.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ElasticsearchRetryOptions implements StructuredPojo,
        ToCopyableBuilder<ElasticsearchRetryOptions.Builder, ElasticsearchRetryOptions> {
    private final Integer durationInSeconds;

    private ElasticsearchRetryOptions(BuilderImpl builder) {
        this.durationInSeconds = builder.durationInSeconds;
    }

    /**
     * <p>
     * After an initial failure to deliver to Amazon ES, the total amount of time during which Kinesis Firehose
     * re-attempts delivery (including the first attempt). After this time has elapsed, the failed documents are written
     * to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero) results in no retries.
     * </p>
     * 
     * @return After an initial failure to deliver to Amazon ES, the total amount of time during which Kinesis Firehose
     *         re-attempts delivery (including the first attempt). After this time has elapsed, the failed documents are
     *         written to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero) results in no
     *         retries.
     */
    public Integer durationInSeconds() {
        return durationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchRetryOptions)) {
            return false;
        }
        ElasticsearchRetryOptions other = (ElasticsearchRetryOptions) obj;
        return Objects.equals(durationInSeconds(), other.durationInSeconds());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (durationInSeconds() != null) {
            sb.append("DurationInSeconds: ").append(durationInSeconds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurationInSeconds":
            return Optional.of(clazz.cast(durationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchRetryOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ElasticsearchRetryOptions> {
        /**
         * <p>
         * After an initial failure to deliver to Amazon ES, the total amount of time during which Kinesis Firehose
         * re-attempts delivery (including the first attempt). After this time has elapsed, the failed documents are
         * written to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero) results in no retries.
         * </p>
         * 
         * @param durationInSeconds
         *        After an initial failure to deliver to Amazon ES, the total amount of time during which Kinesis
         *        Firehose re-attempts delivery (including the first attempt). After this time has elapsed, the failed
         *        documents are written to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero)
         *        results in no retries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer durationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchRetryOptions model) {
            durationInSeconds(model.durationInSeconds);
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public ElasticsearchRetryOptions build() {
            return new ElasticsearchRetryOptions(this);
        }
    }
}
