/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.services.firehose.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * UpdateDestinationRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class UpdateDestinationRequestModelMarshaller {

    private static final MarshallingInfo<String> DELIVERYSTREAMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamName").build();
    private static final MarshallingInfo<String> CURRENTDELIVERYSTREAMVERSIONID_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CurrentDeliveryStreamVersionId").build();
    private static final MarshallingInfo<String> DESTINATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationId").build();
    private static final MarshallingInfo<StructuredPojo> S3DESTINATIONUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("S3DestinationUpdate").build();
    private static final MarshallingInfo<StructuredPojo> EXTENDEDS3DESTINATIONUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ExtendedS3DestinationUpdate").build();
    private static final MarshallingInfo<StructuredPojo> REDSHIFTDESTINATIONUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("RedshiftDestinationUpdate").build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHDESTINATIONUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ElasticsearchDestinationUpdate").build();
    private static final MarshallingInfo<StructuredPojo> SPLUNKDESTINATIONUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("SplunkDestinationUpdate").build();

    private static final UpdateDestinationRequestModelMarshaller INSTANCE = new UpdateDestinationRequestModelMarshaller();

    public static UpdateDestinationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(UpdateDestinationRequest updateDestinationRequest, ProtocolMarshaller protocolMarshaller) {

        if (updateDestinationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(updateDestinationRequest.deliveryStreamName(), DELIVERYSTREAMNAME_BINDING);

            protocolMarshaller.marshall(updateDestinationRequest.currentDeliveryStreamVersionId(),
                    CURRENTDELIVERYSTREAMVERSIONID_BINDING);

            protocolMarshaller.marshall(updateDestinationRequest.destinationId(), DESTINATIONID_BINDING);

            protocolMarshaller.marshall(updateDestinationRequest.s3DestinationUpdate(), S3DESTINATIONUPDATE_BINDING);

            protocolMarshaller.marshall(updateDestinationRequest.extendedS3DestinationUpdate(),
                    EXTENDEDS3DESTINATIONUPDATE_BINDING);

            protocolMarshaller.marshall(updateDestinationRequest.redshiftDestinationUpdate(), REDSHIFTDESTINATIONUPDATE_BINDING);

            protocolMarshaller.marshall(updateDestinationRequest.elasticsearchDestinationUpdate(),
                    ELASTICSEARCHDESTINATIONUPDATE_BINDING);

            protocolMarshaller.marshall(updateDestinationRequest.splunkDestinationUpdate(), SPLUNKDESTINATIONUPDATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
