/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <code>ListStreams</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListStreamsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListStreamsResponse.Builder, ListStreamsResponse> {
    private final List<String> streamNames;

    private final Boolean hasMoreStreams;

    private ListStreamsResponse(BuilderImpl builder) {
        this.streamNames = builder.streamNames;
        this.hasMoreStreams = builder.hasMoreStreams;
    }

    /**
     * <p>
     * The names of the streams that are associated with the AWS account making the <code>ListStreams</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the streams that are associated with the AWS account making the <code>ListStreams</code>
     *         request.
     */
    public List<String> streamNames() {
        return streamNames;
    }

    /**
     * <p>
     * If set to <code>true</code>, there are more streams available to list.
     * </p>
     * 
     * @return If set to <code>true</code>, there are more streams available to list.
     */
    public Boolean hasMoreStreams() {
        return hasMoreStreams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamNames());
        hashCode = 31 * hashCode + Objects.hashCode(hasMoreStreams());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResponse)) {
            return false;
        }
        ListStreamsResponse other = (ListStreamsResponse) obj;
        return Objects.equals(streamNames(), other.streamNames()) && Objects.equals(hasMoreStreams(), other.hasMoreStreams());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (streamNames() != null) {
            sb.append("StreamNames: ").append(streamNames()).append(",");
        }
        if (hasMoreStreams() != null) {
            sb.append("HasMoreStreams: ").append(hasMoreStreams()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamNames":
            return Optional.of(clazz.cast(streamNames()));
        case "HasMoreStreams":
            return Optional.of(clazz.cast(hasMoreStreams()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListStreamsResponse> {
        /**
         * <p>
         * The names of the streams that are associated with the AWS account making the <code>ListStreams</code>
         * request.
         * </p>
         * 
         * @param streamNames
         *        The names of the streams that are associated with the AWS account making the <code>ListStreams</code>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamNames(Collection<String> streamNames);

        /**
         * <p>
         * The names of the streams that are associated with the AWS account making the <code>ListStreams</code>
         * request.
         * </p>
         * 
         * @param streamNames
         *        The names of the streams that are associated with the AWS account making the <code>ListStreams</code>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamNames(String... streamNames);

        /**
         * <p>
         * If set to <code>true</code>, there are more streams available to list.
         * </p>
         * 
         * @param hasMoreStreams
         *        If set to <code>true</code>, there are more streams available to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreStreams(Boolean hasMoreStreams);
    }

    static final class BuilderImpl implements Builder {
        private List<String> streamNames;

        private Boolean hasMoreStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsResponse model) {
            streamNames(model.streamNames);
            hasMoreStreams(model.hasMoreStreams);
        }

        public final Collection<String> getStreamNames() {
            return streamNames;
        }

        @Override
        public final Builder streamNames(Collection<String> streamNames) {
            this.streamNames = StreamNameListCopier.copy(streamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamNames(String... streamNames) {
            streamNames(Arrays.asList(streamNames));
            return this;
        }

        public final void setStreamNames(Collection<String> streamNames) {
            this.streamNames = StreamNameListCopier.copy(streamNames);
        }

        public final Boolean getHasMoreStreams() {
            return hasMoreStreams;
        }

        @Override
        public final Builder hasMoreStreams(Boolean hasMoreStreams) {
            this.hasMoreStreams = hasMoreStreams;
            return this;
        }

        public final void setHasMoreStreams(Boolean hasMoreStreams) {
            this.hasMoreStreams = hasMoreStreams;
        }

        @Override
        public ListStreamsResponse build() {
            return new ListStreamsResponse(this);
        }
    }
}
