/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <code>PutRecords</code> results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PutRecordsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PutRecordsResponse.Builder, PutRecordsResponse> {
    private final Integer failedRecordCount;

    private final List<PutRecordsResultEntry> records;

    private final String encryptionType;

    private PutRecordsResponse(BuilderImpl builder) {
        this.failedRecordCount = builder.failedRecordCount;
        this.records = builder.records;
        this.encryptionType = builder.encryptionType;
    }

    /**
     * <p>
     * The number of unsuccessfully processed records in a <code>PutRecords</code> request.
     * </p>
     * 
     * @return The number of unsuccessfully processed records in a <code>PutRecords</code> request.
     */
    public Integer failedRecordCount() {
        return failedRecordCount;
    }

    /**
     * <p>
     * An array of successfully and unsuccessfully processed record results, correlated with the request by natural
     * ordering. A record that is successfully added to a stream includes <code>SequenceNumber</code> and
     * <code>ShardId</code> in the result. A record that fails to be added to a stream includes <code>ErrorCode</code>
     * and <code>ErrorMessage</code> in the result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of successfully and unsuccessfully processed record results, correlated with the request by
     *         natural ordering. A record that is successfully added to a stream includes <code>SequenceNumber</code>
     *         and <code>ShardId</code> in the result. A record that fails to be added to a stream includes
     *         <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.
     */
    public List<PutRecordsResultEntry> records() {
        return records;
    }

    /**
     * <p>
     * The encryption type used on the records. This parameter can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: Do not encrypt the records.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KMS</code>: Use server-side encryption on the records using a customer-managed KMS key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeString}.
     * </p>
     * 
     * @return The encryption type used on the records. This parameter can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Do not encrypt the records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KMS</code>: Use server-side encryption on the records using a customer-managed KMS key.
     *         </p>
     *         </li>
     * @see EncryptionType
     */
    public EncryptionType encryptionType() {
        return EncryptionType.fromValue(encryptionType);
    }

    /**
     * <p>
     * The encryption type used on the records. This parameter can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: Do not encrypt the records.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KMS</code>: Use server-side encryption on the records using a customer-managed KMS key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeString}.
     * </p>
     * 
     * @return The encryption type used on the records. This parameter can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Do not encrypt the records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KMS</code>: Use server-side encryption on the records using a customer-managed KMS key.
     *         </p>
     *         </li>
     * @see EncryptionType
     */
    public String encryptionTypeString() {
        return encryptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failedRecordCount());
        hashCode = 31 * hashCode + Objects.hashCode(records());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsResponse)) {
            return false;
        }
        PutRecordsResponse other = (PutRecordsResponse) obj;
        return Objects.equals(failedRecordCount(), other.failedRecordCount()) && Objects.equals(records(), other.records())
                && Objects.equals(encryptionTypeString(), other.encryptionTypeString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (failedRecordCount() != null) {
            sb.append("FailedRecordCount: ").append(failedRecordCount()).append(",");
        }
        if (records() != null) {
            sb.append("Records: ").append(records()).append(",");
        }
        if (encryptionTypeString() != null) {
            sb.append("EncryptionType: ").append(encryptionTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedRecordCount":
            return Optional.of(clazz.cast(failedRecordCount()));
        case "Records":
            return Optional.of(clazz.cast(records()));
        case "EncryptionType":
            return Optional.of(clazz.cast(encryptionTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutRecordsResponse> {
        /**
         * <p>
         * The number of unsuccessfully processed records in a <code>PutRecords</code> request.
         * </p>
         * 
         * @param failedRecordCount
         *        The number of unsuccessfully processed records in a <code>PutRecords</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRecordCount(Integer failedRecordCount);

        /**
         * <p>
         * An array of successfully and unsuccessfully processed record results, correlated with the request by natural
         * ordering. A record that is successfully added to a stream includes <code>SequenceNumber</code> and
         * <code>ShardId</code> in the result. A record that fails to be added to a stream includes
         * <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.
         * </p>
         * 
         * @param records
         *        An array of successfully and unsuccessfully processed record results, correlated with the request by
         *        natural ordering. A record that is successfully added to a stream includes <code>SequenceNumber</code>
         *        and <code>ShardId</code> in the result. A record that fails to be added to a stream includes
         *        <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<PutRecordsResultEntry> records);

        /**
         * <p>
         * An array of successfully and unsuccessfully processed record results, correlated with the request by natural
         * ordering. A record that is successfully added to a stream includes <code>SequenceNumber</code> and
         * <code>ShardId</code> in the result. A record that fails to be added to a stream includes
         * <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.
         * </p>
         * 
         * @param records
         *        An array of successfully and unsuccessfully processed record results, correlated with the request by
         *        natural ordering. A record that is successfully added to a stream includes <code>SequenceNumber</code>
         *        and <code>ShardId</code> in the result. A record that fails to be added to a stream includes
         *        <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(PutRecordsResultEntry... records);

        /**
         * <p>
         * The encryption type used on the records. This parameter can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: Do not encrypt the records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KMS</code>: Use server-side encryption on the records using a customer-managed KMS key.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionType
         *        The encryption type used on the records. This parameter can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Do not encrypt the records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KMS</code>: Use server-side encryption on the records using a customer-managed KMS key.
         *        </p>
         *        </li>
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(String encryptionType);

        /**
         * <p>
         * The encryption type used on the records. This parameter can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: Do not encrypt the records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KMS</code>: Use server-side encryption on the records using a customer-managed KMS key.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionType
         *        The encryption type used on the records. This parameter can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Do not encrypt the records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KMS</code>: Use server-side encryption on the records using a customer-managed KMS key.
         *        </p>
         *        </li>
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(EncryptionType encryptionType);
    }

    static final class BuilderImpl implements Builder {
        private Integer failedRecordCount;

        private List<PutRecordsResultEntry> records;

        private String encryptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsResponse model) {
            failedRecordCount(model.failedRecordCount);
            records(model.records);
            encryptionType(model.encryptionType);
        }

        public final Integer getFailedRecordCount() {
            return failedRecordCount;
        }

        @Override
        public final Builder failedRecordCount(Integer failedRecordCount) {
            this.failedRecordCount = failedRecordCount;
            return this;
        }

        public final void setFailedRecordCount(Integer failedRecordCount) {
            this.failedRecordCount = failedRecordCount;
        }

        public final Collection<PutRecordsResultEntry.Builder> getRecords() {
            return records != null ? records.stream().map(PutRecordsResultEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<PutRecordsResultEntry> records) {
            this.records = PutRecordsResultEntryListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(PutRecordsResultEntry... records) {
            records(Arrays.asList(records));
            return this;
        }

        public final void setRecords(Collection<PutRecordsResultEntry.BuilderImpl> records) {
            this.records = PutRecordsResultEntryListCopier.copyFromBuilder(records);
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public PutRecordsResponse build() {
            return new PutRecordsResponse(this);
        }
    }
}
