/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.CSVMappingParametersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides additional mapping information when the record format uses delimiters, such as CSV. For example, the
 * following sample records use CSV format, where the records use the <i>'\n'</i> as the row delimiter and a comma (",")
 * as the column delimiter:
 * </p>
 * <p>
 * <code>"name1", "address1" </code>
 * </p>
 * <p>
 * <code>"name2, "address2"</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CSVMappingParameters implements StructuredPojo,
        ToCopyableBuilder<CSVMappingParameters.Builder, CSVMappingParameters> {
    private final String recordRowDelimiter;

    private final String recordColumnDelimiter;

    private CSVMappingParameters(BuilderImpl builder) {
        this.recordRowDelimiter = builder.recordRowDelimiter;
        this.recordColumnDelimiter = builder.recordColumnDelimiter;
    }

    /**
     * <p>
     * Row delimiter. For example, in a CSV format, <i>'\n'</i> is the typical row delimiter.
     * </p>
     * 
     * @return Row delimiter. For example, in a CSV format, <i>'\n'</i> is the typical row delimiter.
     */
    public String recordRowDelimiter() {
        return recordRowDelimiter;
    }

    /**
     * <p>
     * Column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.
     * </p>
     * 
     * @return Column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.
     */
    public String recordColumnDelimiter() {
        return recordColumnDelimiter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordRowDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(recordColumnDelimiter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CSVMappingParameters)) {
            return false;
        }
        CSVMappingParameters other = (CSVMappingParameters) obj;
        return Objects.equals(recordRowDelimiter(), other.recordRowDelimiter())
                && Objects.equals(recordColumnDelimiter(), other.recordColumnDelimiter());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (recordRowDelimiter() != null) {
            sb.append("RecordRowDelimiter: ").append(recordRowDelimiter()).append(",");
        }
        if (recordColumnDelimiter() != null) {
            sb.append("RecordColumnDelimiter: ").append(recordColumnDelimiter()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordRowDelimiter":
            return Optional.of(clazz.cast(recordRowDelimiter()));
        case "RecordColumnDelimiter":
            return Optional.of(clazz.cast(recordColumnDelimiter()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CSVMappingParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CSVMappingParameters> {
        /**
         * <p>
         * Row delimiter. For example, in a CSV format, <i>'\n'</i> is the typical row delimiter.
         * </p>
         * 
         * @param recordRowDelimiter
         *        Row delimiter. For example, in a CSV format, <i>'\n'</i> is the typical row delimiter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordRowDelimiter(String recordRowDelimiter);

        /**
         * <p>
         * Column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.
         * </p>
         * 
         * @param recordColumnDelimiter
         *        Column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordColumnDelimiter(String recordColumnDelimiter);
    }

    static final class BuilderImpl implements Builder {
        private String recordRowDelimiter;

        private String recordColumnDelimiter;

        private BuilderImpl() {
        }

        private BuilderImpl(CSVMappingParameters model) {
            recordRowDelimiter(model.recordRowDelimiter);
            recordColumnDelimiter(model.recordColumnDelimiter);
        }

        public final String getRecordRowDelimiter() {
            return recordRowDelimiter;
        }

        @Override
        public final Builder recordRowDelimiter(String recordRowDelimiter) {
            this.recordRowDelimiter = recordRowDelimiter;
            return this;
        }

        public final void setRecordRowDelimiter(String recordRowDelimiter) {
            this.recordRowDelimiter = recordRowDelimiter;
        }

        public final String getRecordColumnDelimiter() {
            return recordColumnDelimiter;
        }

        @Override
        public final Builder recordColumnDelimiter(String recordColumnDelimiter) {
            this.recordColumnDelimiter = recordColumnDelimiter;
            return this;
        }

        public final void setRecordColumnDelimiter(String recordColumnDelimiter) {
            this.recordColumnDelimiter = recordColumnDelimiter;
        }

        @Override
        public CSVMappingParameters build() {
            return new CSVMappingParameters(this);
        }
    }
}
