/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * TBD
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateApplicationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateApplicationResponse.Builder, CreateApplicationResponse> {
    private final ApplicationSummary applicationSummary;

    private CreateApplicationResponse(BuilderImpl builder) {
        this.applicationSummary = builder.applicationSummary;
    }

    /**
     * <p>
     * In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a response with a
     * summary of the application it created, including the application Amazon Resource Name (ARN), name, and status.
     * </p>
     * 
     * @return In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a response
     *         with a summary of the application it created, including the application Amazon Resource Name (ARN), name,
     *         and status.
     */
    public ApplicationSummary applicationSummary() {
        return applicationSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationResponse)) {
            return false;
        }
        CreateApplicationResponse other = (CreateApplicationResponse) obj;
        return Objects.equals(applicationSummary(), other.applicationSummary());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (applicationSummary() != null) {
            sb.append("ApplicationSummary: ").append(applicationSummary()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationSummary":
            return Optional.of(clazz.cast(applicationSummary()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateApplicationResponse> {
        /**
         * <p>
         * In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a response with
         * a summary of the application it created, including the application Amazon Resource Name (ARN), name, and
         * status.
         * </p>
         * 
         * @param applicationSummary
         *        In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a
         *        response with a summary of the application it created, including the application Amazon Resource Name
         *        (ARN), name, and status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSummary(ApplicationSummary applicationSummary);

        /**
         * <p>
         * In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a response with
         * a summary of the application it created, including the application Amazon Resource Name (ARN), name, and
         * status.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationSummary.Builder} avoiding the need to
         * create one manually via {@link ApplicationSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationSummary(ApplicationSummary)}.
         * 
         * @param applicationSummary
         *        a consumer that will call methods on {@link ApplicationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSummary(ApplicationSummary)
         */
        default Builder applicationSummary(Consumer<ApplicationSummary.Builder> applicationSummary) {
            return applicationSummary(ApplicationSummary.builder().apply(applicationSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ApplicationSummary applicationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationResponse model) {
            applicationSummary(model.applicationSummary);
        }

        public final ApplicationSummary.Builder getApplicationSummary() {
            return applicationSummary != null ? applicationSummary.toBuilder() : null;
        }

        @Override
        public final Builder applicationSummary(ApplicationSummary applicationSummary) {
            this.applicationSummary = applicationSummary;
            return this;
        }

        public final void setApplicationSummary(ApplicationSummary.BuilderImpl applicationSummary) {
            this.applicationSummary = applicationSummary != null ? applicationSummary.build() : null;
        }

        @Override
        public CreateApplicationResponse build() {
            return new CreateApplicationResponse(this);
        }
    }
}
