/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteApplicationOutputRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteApplicationOutputRequest.Builder, DeleteApplicationOutputRequest> {
    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final String outputId;

    private DeleteApplicationOutputRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.outputId = builder.outputId;
    }

    /**
     * <p>
     * Amazon Kinesis Analytics application name.
     * </p>
     * 
     * @return Amazon Kinesis Analytics application name.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Amazon Kinesis Analytics application version. You can use the <a>DescribeApplication</a> operation to get the
     * current application version. If the version specified is not the current version, the
     * <code>ConcurrentModificationException</code> is returned.
     * </p>
     * 
     * @return Amazon Kinesis Analytics application version. You can use the <a>DescribeApplication</a> operation to get
     *         the current application version. If the version specified is not the current version, the
     *         <code>ConcurrentModificationException</code> is returned.
     */
    public Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * The ID of the configuration to delete. Each output configuration that is added to the application, either when
     * the application is created or later using the <a>AddApplicationOutput</a> operation, has a unique ID. You need to
     * provide the ID to uniquely identify the output configuration that you want to delete from the application
     * configuration. You can use the <a>DescribeApplication</a> operation to get the specific <code>OutputId</code>.
     * </p>
     * 
     * @return The ID of the configuration to delete. Each output configuration that is added to the application, either
     *         when the application is created or later using the <a>AddApplicationOutput</a> operation, has a unique
     *         ID. You need to provide the ID to uniquely identify the output configuration that you want to delete from
     *         the application configuration. You can use the <a>DescribeApplication</a> operation to get the specific
     *         <code>OutputId</code>.
     */
    public String outputId() {
        return outputId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(outputId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationOutputRequest)) {
            return false;
        }
        DeleteApplicationOutputRequest other = (DeleteApplicationOutputRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(outputId(), other.outputId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(currentApplicationVersionId()).append(",");
        }
        if (outputId() != null) {
            sb.append("OutputId: ").append(outputId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.of(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.of(clazz.cast(currentApplicationVersionId()));
        case "OutputId":
            return Optional.of(clazz.cast(outputId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteApplicationOutputRequest> {
        /**
         * <p>
         * Amazon Kinesis Analytics application name.
         * </p>
         * 
         * @param applicationName
         *        Amazon Kinesis Analytics application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Amazon Kinesis Analytics application version. You can use the <a>DescribeApplication</a> operation to get the
         * current application version. If the version specified is not the current version, the
         * <code>ConcurrentModificationException</code> is returned.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        Amazon Kinesis Analytics application version. You can use the <a>DescribeApplication</a> operation to
         *        get the current application version. If the version specified is not the current version, the
         *        <code>ConcurrentModificationException</code> is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * The ID of the configuration to delete. Each output configuration that is added to the application, either
         * when the application is created or later using the <a>AddApplicationOutput</a> operation, has a unique ID.
         * You need to provide the ID to uniquely identify the output configuration that you want to delete from the
         * application configuration. You can use the <a>DescribeApplication</a> operation to get the specific
         * <code>OutputId</code>.
         * </p>
         * 
         * @param outputId
         *        The ID of the configuration to delete. Each output configuration that is added to the application,
         *        either when the application is created or later using the <a>AddApplicationOutput</a> operation, has a
         *        unique ID. You need to provide the ID to uniquely identify the output configuration that you want to
         *        delete from the application configuration. You can use the <a>DescribeApplication</a> operation to get
         *        the specific <code>OutputId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputId(String outputId);
    }

    static final class BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private String outputId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationOutputRequest model) {
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            outputId(model.outputId);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final String getOutputId() {
            return outputId;
        }

        @Override
        public final Builder outputId(String outputId) {
            this.outputId = outputId;
            return this;
        }

        public final void setOutputId(String outputId) {
            this.outputId = outputId;
        }

        @Override
        public DeleteApplicationOutputRequest build() {
            return new DeleteApplicationOutputRequest(this);
        }
    }
}
