/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteApplicationReferenceDataSourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteApplicationReferenceDataSourceRequest.Builder, DeleteApplicationReferenceDataSourceRequest> {
    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final String referenceId;

    private DeleteApplicationReferenceDataSourceRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.referenceId = builder.referenceId;
    }

    /**
     * <p>
     * Name of an existing application.
     * </p>
     * 
     * @return Name of an existing application.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Version of the application. You can use the <a>DescribeApplication</a> operation to get the current application
     * version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is
     * returned.
     * </p>
     * 
     * @return Version of the application. You can use the <a>DescribeApplication</a> operation to get the current
     *         application version. If the version specified is not the current version, the
     *         <code>ConcurrentModificationException</code> is returned.
     */
    public Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * ID of the reference data source. When you add a reference data source to your application using the
     * <a>AddApplicationReferenceDataSource</a>, Amazon Kinesis Analytics assigns an ID. You can use the
     * <a>DescribeApplication</a> operation to get the reference ID.
     * </p>
     * 
     * @return ID of the reference data source. When you add a reference data source to your application using the
     *         <a>AddApplicationReferenceDataSource</a>, Amazon Kinesis Analytics assigns an ID. You can use the
     *         <a>DescribeApplication</a> operation to get the reference ID.
     */
    public String referenceId() {
        return referenceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationReferenceDataSourceRequest)) {
            return false;
        }
        DeleteApplicationReferenceDataSourceRequest other = (DeleteApplicationReferenceDataSourceRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(referenceId(), other.referenceId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(currentApplicationVersionId()).append(",");
        }
        if (referenceId() != null) {
            sb.append("ReferenceId: ").append(referenceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.of(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.of(clazz.cast(currentApplicationVersionId()));
        case "ReferenceId":
            return Optional.of(clazz.cast(referenceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteApplicationReferenceDataSourceRequest> {
        /**
         * <p>
         * Name of an existing application.
         * </p>
         * 
         * @param applicationName
         *        Name of an existing application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Version of the application. You can use the <a>DescribeApplication</a> operation to get the current
         * application version. If the version specified is not the current version, the
         * <code>ConcurrentModificationException</code> is returned.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        Version of the application. You can use the <a>DescribeApplication</a> operation to get the current
         *        application version. If the version specified is not the current version, the
         *        <code>ConcurrentModificationException</code> is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * ID of the reference data source. When you add a reference data source to your application using the
         * <a>AddApplicationReferenceDataSource</a>, Amazon Kinesis Analytics assigns an ID. You can use the
         * <a>DescribeApplication</a> operation to get the reference ID.
         * </p>
         * 
         * @param referenceId
         *        ID of the reference data source. When you add a reference data source to your application using the
         *        <a>AddApplicationReferenceDataSource</a>, Amazon Kinesis Analytics assigns an ID. You can use the
         *        <a>DescribeApplication</a> operation to get the reference ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(String referenceId);
    }

    static final class BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private String referenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationReferenceDataSourceRequest model) {
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            referenceId(model.referenceId);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final String getReferenceId() {
            return referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public DeleteApplicationReferenceDataSourceRequest build() {
            return new DeleteApplicationReferenceDataSourceRequest(this);
        }
    }
}
