/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisStreamsOutputUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When updating an output configuration using the <a>UpdateApplication</a> operation, provides information about an
 * Amazon Kinesis stream configured as the destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KinesisStreamsOutputUpdate implements StructuredPojo,
        ToCopyableBuilder<KinesisStreamsOutputUpdate.Builder, KinesisStreamsOutputUpdate> {
    private final String resourceARNUpdate;

    private final String roleARNUpdate;

    private KinesisStreamsOutputUpdate(BuilderImpl builder) {
        this.resourceARNUpdate = builder.resourceARNUpdate;
        this.roleARNUpdate = builder.roleARNUpdate;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Amazon Kinesis stream where you want to write the output.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Amazon Kinesis stream where you want to write the output.
     */
    public String resourceARNUpdate() {
        return resourceARNUpdate;
    }

    /**
     * <p>
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to
     * grant the necessary permissions to this role.
     * </p>
     * 
     * @return ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You
     *         need to grant the necessary permissions to this role.
     */
    public String roleARNUpdate() {
        return roleARNUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceARNUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(roleARNUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamsOutputUpdate)) {
            return false;
        }
        KinesisStreamsOutputUpdate other = (KinesisStreamsOutputUpdate) obj;
        return Objects.equals(resourceARNUpdate(), other.resourceARNUpdate())
                && Objects.equals(roleARNUpdate(), other.roleARNUpdate());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (resourceARNUpdate() != null) {
            sb.append("ResourceARNUpdate: ").append(resourceARNUpdate()).append(",");
        }
        if (roleARNUpdate() != null) {
            sb.append("RoleARNUpdate: ").append(roleARNUpdate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceARNUpdate":
            return Optional.of(clazz.cast(resourceARNUpdate()));
        case "RoleARNUpdate":
            return Optional.of(clazz.cast(roleARNUpdate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisStreamsOutputUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KinesisStreamsOutputUpdate> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Amazon Kinesis stream where you want to write the output.
         * </p>
         * 
         * @param resourceARNUpdate
         *        Amazon Resource Name (ARN) of the Amazon Kinesis stream where you want to write the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARNUpdate(String resourceARNUpdate);

        /**
         * <p>
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to
         * grant the necessary permissions to this role.
         * </p>
         * 
         * @param roleARNUpdate
         *        ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You
         *        need to grant the necessary permissions to this role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARNUpdate(String roleARNUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String resourceARNUpdate;

        private String roleARNUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamsOutputUpdate model) {
            resourceARNUpdate(model.resourceARNUpdate);
            roleARNUpdate(model.roleARNUpdate);
        }

        public final String getResourceARNUpdate() {
            return resourceARNUpdate;
        }

        @Override
        public final Builder resourceARNUpdate(String resourceARNUpdate) {
            this.resourceARNUpdate = resourceARNUpdate;
            return this;
        }

        public final void setResourceARNUpdate(String resourceARNUpdate) {
            this.resourceARNUpdate = resourceARNUpdate;
        }

        public final String getRoleARNUpdate() {
            return roleARNUpdate;
        }

        @Override
        public final Builder roleARNUpdate(String roleARNUpdate) {
            this.roleARNUpdate = roleARNUpdate;
            return this;
        }

        public final void setRoleARNUpdate(String roleARNUpdate) {
            this.roleARNUpdate = roleARNUpdate;
        }

        @Override
        public KinesisStreamsOutputUpdate build() {
            return new KinesisStreamsOutputUpdate(this);
        }
    }
}
