/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data format is not valid, Amazon Kinesis Analytics is not able to detect schema for the given streaming source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UnableToDetectSchemaException extends KinesisAnalyticsException implements
        ToCopyableBuilder<UnableToDetectSchemaException.Builder, UnableToDetectSchemaException> {
    private final List<String> rawInputRecords;

    private final List<String> processedInputRecords;

    private UnableToDetectSchemaException(BuilderImpl builder) {
        super(builder.message);
        this.rawInputRecords = builder.rawInputRecords;
        this.processedInputRecords = builder.processedInputRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the RawInputRecords property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the RawInputRecords property for this object.
     */
    public List<String> rawInputRecords() {
        return rawInputRecords;
    }

    /**
     * Returns the value of the ProcessedInputRecords property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ProcessedInputRecords property for this object.
     */
    public List<String> processedInputRecords() {
        return processedInputRecords;
    }

    public interface Builder extends CopyableBuilder<Builder, UnableToDetectSchemaException> {
        /**
         * Sets the value of the RawInputRecords property for this object.
         *
         * @param rawInputRecords
         *        The new value for the RawInputRecords property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawInputRecords(Collection<String> rawInputRecords);

        /**
         * Sets the value of the RawInputRecords property for this object.
         *
         * @param rawInputRecords
         *        The new value for the RawInputRecords property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawInputRecords(String... rawInputRecords);

        /**
         * Sets the value of the ProcessedInputRecords property for this object.
         *
         * @param processedInputRecords
         *        The new value for the ProcessedInputRecords property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedInputRecords(Collection<String> processedInputRecords);

        /**
         * Sets the value of the ProcessedInputRecords property for this object.
         *
         * @param processedInputRecords
         *        The new value for the ProcessedInputRecords property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedInputRecords(String... processedInputRecords);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private List<String> rawInputRecords;

        private List<String> processedInputRecords;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(UnableToDetectSchemaException model) {
            rawInputRecords(model.rawInputRecords);
            processedInputRecords(model.processedInputRecords);
            this.message = model.getMessage();
        }

        public final Collection<String> getRawInputRecords() {
            return rawInputRecords;
        }

        @Override
        public final Builder rawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rawInputRecords(String... rawInputRecords) {
            rawInputRecords(Arrays.asList(rawInputRecords));
            return this;
        }

        @JsonProperty("RawInputRecords")
        public final void setRawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
        }

        public final Collection<String> getProcessedInputRecords() {
            return processedInputRecords;
        }

        @Override
        public final Builder processedInputRecords(Collection<String> processedInputRecords) {
            this.processedInputRecords = ProcessedInputRecordsCopier.copy(processedInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedInputRecords(String... processedInputRecords) {
            processedInputRecords(Arrays.asList(processedInputRecords));
            return this;
        }

        @JsonProperty("ProcessedInputRecords")
        public final void setProcessedInputRecords(Collection<String> processedInputRecords) {
            this.processedInputRecords = ProcessedInputRecordsCopier.copy(processedInputRecords);
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public UnableToDetectSchemaException build() {
            return new UnableToDetectSchemaException(this);
        }
    }
}
