/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.services.kinesisanalytics.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * OutputUpdateMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class OutputUpdateMarshaller {

    private static final MarshallingInfo<String> OUTPUTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputId").build();
    private static final MarshallingInfo<String> NAMEUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NameUpdate").build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOUTPUTUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisStreamsOutputUpdate").build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEOUTPUTUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisFirehoseOutputUpdate").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONSCHEMAUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DestinationSchemaUpdate").build();

    private static final OutputUpdateMarshaller INSTANCE = new OutputUpdateMarshaller();

    public static OutputUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(OutputUpdate outputUpdate, ProtocolMarshaller protocolMarshaller) {

        if (outputUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(outputUpdate.outputId(), OUTPUTID_BINDING);

            protocolMarshaller.marshall(outputUpdate.nameUpdate(), NAMEUPDATE_BINDING);

            protocolMarshaller.marshall(outputUpdate.kinesisStreamsOutputUpdate(), KINESISSTREAMSOUTPUTUPDATE_BINDING);

            protocolMarshaller.marshall(outputUpdate.kinesisFirehoseOutputUpdate(), KINESISFIREHOSEOUTPUTUPDATE_BINDING);

            protocolMarshaller.marshall(outputUpdate.destinationSchemaUpdate(), DESTINATIONSCHEMAUPDATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
