/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamType;
import software.amazon.awssdk.services.firehose.model.DestinationDescription;
import software.amazon.awssdk.services.firehose.model.DestinationDescriptionListCopier;
import software.amazon.awssdk.services.firehose.model.SourceDescription;
import software.amazon.awssdk.services.firehose.transform.DeliveryStreamDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeliveryStreamDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, DeliveryStreamDescription> {
    private final String deliveryStreamName;
    private final String deliveryStreamARN;
    private final String deliveryStreamStatus;
    private final String deliveryStreamType;
    private final String versionId;
    private final Instant createTimestamp;
    private final Instant lastUpdateTimestamp;
    private final SourceDescription source;
    private final List<DestinationDescription> destinations;
    private final Boolean hasMoreDestinations;

    private DeliveryStreamDescription(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.deliveryStreamARN = builder.deliveryStreamARN;
        this.deliveryStreamStatus = builder.deliveryStreamStatus;
        this.deliveryStreamType = builder.deliveryStreamType;
        this.versionId = builder.versionId;
        this.createTimestamp = builder.createTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.source = builder.source;
        this.destinations = builder.destinations;
        this.hasMoreDestinations = builder.hasMoreDestinations;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public String deliveryStreamARN() {
        return this.deliveryStreamARN;
    }

    public DeliveryStreamStatus deliveryStreamStatus() {
        return DeliveryStreamStatus.fromValue(this.deliveryStreamStatus);
    }

    public String deliveryStreamStatusString() {
        return this.deliveryStreamStatus;
    }

    public DeliveryStreamType deliveryStreamType() {
        return DeliveryStreamType.fromValue(this.deliveryStreamType);
    }

    public String deliveryStreamTypeString() {
        return this.deliveryStreamType;
    }

    public String versionId() {
        return this.versionId;
    }

    public Instant createTimestamp() {
        return this.createTimestamp;
    }

    public Instant lastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public SourceDescription source() {
        return this.source;
    }

    public List<DestinationDescription> destinations() {
        return this.destinations;
    }

    public Boolean hasMoreDestinations() {
        return this.hasMoreDestinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreDestinations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryStreamDescription)) {
            return false;
        }
        DeliveryStreamDescription other = (DeliveryStreamDescription)obj;
        return Objects.equals(this.deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(this.deliveryStreamARN(), other.deliveryStreamARN()) && Objects.equals(this.deliveryStreamStatusString(), other.deliveryStreamStatusString()) && Objects.equals(this.deliveryStreamTypeString(), other.deliveryStreamTypeString()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.createTimestamp(), other.createTimestamp()) && Objects.equals(this.lastUpdateTimestamp(), other.lastUpdateTimestamp()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.hasMoreDestinations(), other.hasMoreDestinations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(this.deliveryStreamName()).append(",");
        }
        if (this.deliveryStreamARN() != null) {
            sb.append("DeliveryStreamARN: ").append(this.deliveryStreamARN()).append(",");
        }
        if (this.deliveryStreamStatusString() != null) {
            sb.append("DeliveryStreamStatus: ").append(this.deliveryStreamStatusString()).append(",");
        }
        if (this.deliveryStreamTypeString() != null) {
            sb.append("DeliveryStreamType: ").append(this.deliveryStreamTypeString()).append(",");
        }
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        if (this.createTimestamp() != null) {
            sb.append("CreateTimestamp: ").append(this.createTimestamp()).append(",");
        }
        if (this.lastUpdateTimestamp() != null) {
            sb.append("LastUpdateTimestamp: ").append(this.lastUpdateTimestamp()).append(",");
        }
        if (this.source() != null) {
            sb.append("Source: ").append(this.source()).append(",");
        }
        if (this.destinations() != null) {
            sb.append("Destinations: ").append(this.destinations()).append(",");
        }
        if (this.hasMoreDestinations() != null) {
            sb.append("HasMoreDestinations: ").append(this.hasMoreDestinations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamName": {
                return Optional.of(clazz.cast(this.deliveryStreamName()));
            }
            case "DeliveryStreamARN": {
                return Optional.of(clazz.cast(this.deliveryStreamARN()));
            }
            case "DeliveryStreamStatus": {
                return Optional.of(clazz.cast(this.deliveryStreamStatusString()));
            }
            case "DeliveryStreamType": {
                return Optional.of(clazz.cast(this.deliveryStreamTypeString()));
            }
            case "VersionId": {
                return Optional.of(clazz.cast(this.versionId()));
            }
            case "CreateTimestamp": {
                return Optional.of(clazz.cast(this.createTimestamp()));
            }
            case "LastUpdateTimestamp": {
                return Optional.of(clazz.cast(this.lastUpdateTimestamp()));
            }
            case "Source": {
                return Optional.of(clazz.cast(this.source()));
            }
            case "Destinations": {
                return Optional.of(clazz.cast(this.destinations()));
            }
            case "HasMoreDestinations": {
                return Optional.of(clazz.cast(this.hasMoreDestinations()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeliveryStreamDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private String deliveryStreamARN;
        private String deliveryStreamStatus;
        private String deliveryStreamType;
        private String versionId;
        private Instant createTimestamp;
        private Instant lastUpdateTimestamp;
        private SourceDescription source;
        private List<DestinationDescription> destinations;
        private Boolean hasMoreDestinations;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryStreamDescription model) {
            this.deliveryStreamName(model.deliveryStreamName);
            this.deliveryStreamARN(model.deliveryStreamARN);
            this.deliveryStreamStatus(model.deliveryStreamStatus);
            this.deliveryStreamType(model.deliveryStreamType);
            this.versionId(model.versionId);
            this.createTimestamp(model.createTimestamp);
            this.lastUpdateTimestamp(model.lastUpdateTimestamp);
            this.source(model.source);
            this.destinations(model.destinations);
            this.hasMoreDestinations(model.hasMoreDestinations);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getDeliveryStreamARN() {
            return this.deliveryStreamARN;
        }

        @Override
        public final Builder deliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
            return this;
        }

        public final void setDeliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
        }

        public final String getDeliveryStreamStatus() {
            return this.deliveryStreamStatus;
        }

        @Override
        public final Builder deliveryStreamStatus(String deliveryStreamStatus) {
            this.deliveryStreamStatus = deliveryStreamStatus;
            return this;
        }

        @Override
        public final Builder deliveryStreamStatus(DeliveryStreamStatus deliveryStreamStatus) {
            this.deliveryStreamStatus(deliveryStreamStatus.toString());
            return this;
        }

        public final void setDeliveryStreamStatus(String deliveryStreamStatus) {
            this.deliveryStreamStatus = deliveryStreamStatus;
        }

        public final String getDeliveryStreamType() {
            return this.deliveryStreamType;
        }

        @Override
        public final Builder deliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
            return this;
        }

        @Override
        public final Builder deliveryStreamType(DeliveryStreamType deliveryStreamType) {
            this.deliveryStreamType(deliveryStreamType.toString());
            return this;
        }

        public final void setDeliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        public final Instant getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        public final SourceDescription.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(SourceDescription source) {
            this.source = source;
            return this;
        }

        public final void setSource(SourceDescription.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final Collection<DestinationDescription.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(DestinationDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<DestinationDescription> destinations) {
            this.destinations = DestinationDescriptionListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(DestinationDescription ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        public final void setDestinations(Collection<DestinationDescription.BuilderImpl> destinations) {
            this.destinations = DestinationDescriptionListCopier.copyFromBuilder(destinations);
        }

        public final Boolean getHasMoreDestinations() {
            return this.hasMoreDestinations;
        }

        @Override
        public final Builder hasMoreDestinations(Boolean hasMoreDestinations) {
            this.hasMoreDestinations = hasMoreDestinations;
            return this;
        }

        public final void setHasMoreDestinations(Boolean hasMoreDestinations) {
            this.hasMoreDestinations = hasMoreDestinations;
        }

        public DeliveryStreamDescription build() {
            return new DeliveryStreamDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeliveryStreamDescription> {
        public Builder deliveryStreamName(String var1);

        public Builder deliveryStreamARN(String var1);

        public Builder deliveryStreamStatus(String var1);

        public Builder deliveryStreamStatus(DeliveryStreamStatus var1);

        public Builder deliveryStreamType(String var1);

        public Builder deliveryStreamType(DeliveryStreamType var1);

        public Builder versionId(String var1);

        public Builder createTimestamp(Instant var1);

        public Builder lastUpdateTimestamp(Instant var1);

        public Builder source(SourceDescription var1);

        default public Builder source(Consumer<SourceDescription.Builder> source) {
            return this.source((SourceDescription)((SourceDescription.Builder)SourceDescription.builder().apply(source)).build());
        }

        public Builder destinations(Collection<DestinationDescription> var1);

        public Builder destinations(DestinationDescription ... var1);

        public Builder hasMoreDestinations(Boolean var1);
    }
}

