/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.firehose.model.EncryptionConfiguration;
import software.amazon.awssdk.services.firehose.transform.KMSEncryptionConfigUnmarshaller;

public class EncryptionConfigurationUnmarshaller
implements Unmarshaller<EncryptionConfiguration, JsonUnmarshallerContext> {
    private static final EncryptionConfigurationUnmarshaller INSTANCE = new EncryptionConfigurationUnmarshaller();

    public EncryptionConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        EncryptionConfiguration.Builder encryptionConfigurationBuilder = EncryptionConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("NoEncryptionConfig", targetDepth)) {
                    context.nextToken();
                    encryptionConfigurationBuilder.noEncryptionConfig((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KMSEncryptionConfig", targetDepth)) {
                    context.nextToken();
                    encryptionConfigurationBuilder.kmsEncryptionConfig(KMSEncryptionConfigUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EncryptionConfiguration)encryptionConfigurationBuilder.build();
    }

    public static EncryptionConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

