/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SplitShardRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SplitShardRequest> {
    private final String streamName;
    private final String shardToSplit;
    private final String newStartingHashKey;

    private SplitShardRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.shardToSplit = builder.shardToSplit;
        this.newStartingHashKey = builder.newStartingHashKey;
    }

    public String streamName() {
        return this.streamName;
    }

    public String shardToSplit() {
        return this.shardToSplit;
    }

    public String newStartingHashKey() {
        return this.newStartingHashKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardToSplit());
        hashCode = 31 * hashCode + Objects.hashCode(this.newStartingHashKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SplitShardRequest)) {
            return false;
        }
        SplitShardRequest other = (SplitShardRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.shardToSplit(), other.shardToSplit()) && Objects.equals(this.newStartingHashKey(), other.newStartingHashKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.shardToSplit() != null) {
            sb.append("ShardToSplit: ").append(this.shardToSplit()).append(",");
        }
        if (this.newStartingHashKey() != null) {
            sb.append("NewStartingHashKey: ").append(this.newStartingHashKey()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "ShardToSplit": {
                return Optional.of(clazz.cast(this.shardToSplit()));
            }
            case "NewStartingHashKey": {
                return Optional.of(clazz.cast(this.newStartingHashKey()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String shardToSplit;
        private String newStartingHashKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SplitShardRequest model) {
            this.streamName(model.streamName);
            this.shardToSplit(model.shardToSplit);
            this.newStartingHashKey(model.newStartingHashKey);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getShardToSplit() {
            return this.shardToSplit;
        }

        @Override
        public final Builder shardToSplit(String shardToSplit) {
            this.shardToSplit = shardToSplit;
            return this;
        }

        public final void setShardToSplit(String shardToSplit) {
            this.shardToSplit = shardToSplit;
        }

        public final String getNewStartingHashKey() {
            return this.newStartingHashKey;
        }

        @Override
        public final Builder newStartingHashKey(String newStartingHashKey) {
            this.newStartingHashKey = newStartingHashKey;
            return this;
        }

        public final void setNewStartingHashKey(String newStartingHashKey) {
            this.newStartingHashKey = newStartingHashKey;
        }

        public SplitShardRequest build() {
            return new SplitShardRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SplitShardRequest> {
        public Builder streamName(String var1);

        public Builder shardToSplit(String var1);

        public Builder newStartingHashKey(String var1);
    }
}

