/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StopStreamEncryptionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, StopStreamEncryptionRequest> {
    private final String streamName;
    private final String encryptionType;
    private final String keyId;

    private StopStreamEncryptionRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.encryptionType = builder.encryptionType;
        this.keyId = builder.keyId;
    }

    public String streamName() {
        return this.streamName;
    }

    public EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public String encryptionTypeString() {
        return this.encryptionType;
    }

    public String keyId() {
        return this.keyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopStreamEncryptionRequest)) {
            return false;
        }
        StopStreamEncryptionRequest other = (StopStreamEncryptionRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.encryptionTypeString(), other.encryptionTypeString()) && Objects.equals(this.keyId(), other.keyId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.encryptionTypeString() != null) {
            sb.append("EncryptionType: ").append(this.encryptionTypeString()).append(",");
        }
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "EncryptionType": {
                return Optional.of(clazz.cast(this.encryptionTypeString()));
            }
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String encryptionType;
        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(StopStreamEncryptionRequest model) {
            this.streamName(model.streamName);
            this.encryptionType(model.encryptionType);
            this.keyId(model.keyId);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public StopStreamEncryptionRequest build() {
            return new StopStreamEncryptionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StopStreamEncryptionRequest> {
        public Builder streamName(String var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);

        public Builder keyId(String var1);
    }
}

