/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.SequenceNumberRange;

@SdkInternalApi
public class SequenceNumberRangeMarshaller {
    private static final MarshallingInfo<String> STARTINGSEQUENCENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartingSequenceNumber").build();
    private static final MarshallingInfo<String> ENDINGSEQUENCENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndingSequenceNumber").build();
    private static final SequenceNumberRangeMarshaller INSTANCE = new SequenceNumberRangeMarshaller();

    public static SequenceNumberRangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SequenceNumberRange sequenceNumberRange, ProtocolMarshaller protocolMarshaller) {
        if (sequenceNumberRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sequenceNumberRange.startingSequenceNumber(), STARTINGSEQUENCENUMBER_BINDING);
            protocolMarshaller.marshall((Object)sequenceNumberRange.endingSequenceNumber(), ENDINGSEQUENCENUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

