/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddApplicationReferenceDataSourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddApplicationReferenceDataSourceRequest> {
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final ReferenceDataSource referenceDataSource;

    private AddApplicationReferenceDataSourceRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.referenceDataSource = builder.referenceDataSource;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public ReferenceDataSource referenceDataSource() {
        return this.referenceDataSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceDataSource());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationReferenceDataSourceRequest)) {
            return false;
        }
        AddApplicationReferenceDataSourceRequest other = (AddApplicationReferenceDataSourceRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.currentApplicationVersionId(), other.currentApplicationVersionId()) && Objects.equals(this.referenceDataSource(), other.referenceDataSource());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(this.currentApplicationVersionId()).append(",");
        }
        if (this.referenceDataSource() != null) {
            sb.append("ReferenceDataSource: ").append(this.referenceDataSource()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "CurrentApplicationVersionId": {
                return Optional.of(clazz.cast(this.currentApplicationVersionId()));
            }
            case "ReferenceDataSource": {
                return Optional.of(clazz.cast(this.referenceDataSource()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private ReferenceDataSource referenceDataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationReferenceDataSourceRequest model) {
            this.applicationName(model.applicationName);
            this.currentApplicationVersionId(model.currentApplicationVersionId);
            this.referenceDataSource(model.referenceDataSource);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final ReferenceDataSource.Builder getReferenceDataSource() {
            return this.referenceDataSource != null ? this.referenceDataSource.toBuilder() : null;
        }

        @Override
        public final Builder referenceDataSource(ReferenceDataSource referenceDataSource) {
            this.referenceDataSource = referenceDataSource;
            return this;
        }

        public final void setReferenceDataSource(ReferenceDataSource.BuilderImpl referenceDataSource) {
            this.referenceDataSource = referenceDataSource != null ? referenceDataSource.build() : null;
        }

        public AddApplicationReferenceDataSourceRequest build() {
            return new AddApplicationReferenceDataSourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddApplicationReferenceDataSourceRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder referenceDataSource(ReferenceDataSource var1);

        default public Builder referenceDataSource(Consumer<ReferenceDataSource.Builder> referenceDataSource) {
            return this.referenceDataSource((ReferenceDataSource)((ReferenceDataSource.Builder)ReferenceDataSource.builder().apply(referenceDataSource)).build());
        }
    }
}

