/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.CSVMappingParametersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CSVMappingParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, CSVMappingParameters> {
    private final String recordRowDelimiter;
    private final String recordColumnDelimiter;

    private CSVMappingParameters(BuilderImpl builder) {
        this.recordRowDelimiter = builder.recordRowDelimiter;
        this.recordColumnDelimiter = builder.recordColumnDelimiter;
    }

    public String recordRowDelimiter() {
        return this.recordRowDelimiter;
    }

    public String recordColumnDelimiter() {
        return this.recordColumnDelimiter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordRowDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordColumnDelimiter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CSVMappingParameters)) {
            return false;
        }
        CSVMappingParameters other = (CSVMappingParameters)obj;
        return Objects.equals(this.recordRowDelimiter(), other.recordRowDelimiter()) && Objects.equals(this.recordColumnDelimiter(), other.recordColumnDelimiter());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.recordRowDelimiter() != null) {
            sb.append("RecordRowDelimiter: ").append(this.recordRowDelimiter()).append(",");
        }
        if (this.recordColumnDelimiter() != null) {
            sb.append("RecordColumnDelimiter: ").append(this.recordColumnDelimiter()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordRowDelimiter": {
                return Optional.of(clazz.cast(this.recordRowDelimiter()));
            }
            case "RecordColumnDelimiter": {
                return Optional.of(clazz.cast(this.recordColumnDelimiter()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CSVMappingParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String recordRowDelimiter;
        private String recordColumnDelimiter;

        private BuilderImpl() {
        }

        private BuilderImpl(CSVMappingParameters model) {
            this.recordRowDelimiter(model.recordRowDelimiter);
            this.recordColumnDelimiter(model.recordColumnDelimiter);
        }

        public final String getRecordRowDelimiter() {
            return this.recordRowDelimiter;
        }

        @Override
        public final Builder recordRowDelimiter(String recordRowDelimiter) {
            this.recordRowDelimiter = recordRowDelimiter;
            return this;
        }

        public final void setRecordRowDelimiter(String recordRowDelimiter) {
            this.recordRowDelimiter = recordRowDelimiter;
        }

        public final String getRecordColumnDelimiter() {
            return this.recordColumnDelimiter;
        }

        @Override
        public final Builder recordColumnDelimiter(String recordColumnDelimiter) {
            this.recordColumnDelimiter = recordColumnDelimiter;
            return this;
        }

        public final void setRecordColumnDelimiter(String recordColumnDelimiter) {
            this.recordColumnDelimiter = recordColumnDelimiter;
        }

        public CSVMappingParameters build() {
            return new CSVMappingParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CSVMappingParameters> {
        public Builder recordRowDelimiter(String var1);

        public Builder recordColumnDelimiter(String var1);
    }
}

