/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateApplicationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateApplicationRequest> {
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final ApplicationUpdate applicationUpdate;

    private UpdateApplicationRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.applicationUpdate = builder.applicationUpdate;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public ApplicationUpdate applicationUpdate() {
        return this.applicationUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.currentApplicationVersionId(), other.currentApplicationVersionId()) && Objects.equals(this.applicationUpdate(), other.applicationUpdate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(this.currentApplicationVersionId()).append(",");
        }
        if (this.applicationUpdate() != null) {
            sb.append("ApplicationUpdate: ").append(this.applicationUpdate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "CurrentApplicationVersionId": {
                return Optional.of(clazz.cast(this.currentApplicationVersionId()));
            }
            case "ApplicationUpdate": {
                return Optional.of(clazz.cast(this.applicationUpdate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private ApplicationUpdate applicationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            this.applicationName(model.applicationName);
            this.currentApplicationVersionId(model.currentApplicationVersionId);
            this.applicationUpdate(model.applicationUpdate);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final ApplicationUpdate.Builder getApplicationUpdate() {
            return this.applicationUpdate != null ? this.applicationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder applicationUpdate(ApplicationUpdate applicationUpdate) {
            this.applicationUpdate = applicationUpdate;
            return this;
        }

        public final void setApplicationUpdate(ApplicationUpdate.BuilderImpl applicationUpdate) {
            this.applicationUpdate = applicationUpdate != null ? applicationUpdate.build() : null;
        }

        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder applicationUpdate(ApplicationUpdate var1);

        default public Builder applicationUpdate(Consumer<ApplicationUpdate.Builder> applicationUpdate) {
            return this.applicationUpdate((ApplicationUpdate)((ApplicationUpdate.Builder)ApplicationUpdate.builder().apply(applicationUpdate)).build());
        }
    }
}

