/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate;

@SdkInternalApi
public class ApplicationUpdateMarshaller {
    private static final MarshallingInfo<List> INPUTUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputUpdates").build();
    private static final MarshallingInfo<String> APPLICATIONCODEUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationCodeUpdate").build();
    private static final MarshallingInfo<List> OUTPUTUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputUpdates").build();
    private static final MarshallingInfo<List> REFERENCEDATASOURCEUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceDataSourceUpdates").build();
    private static final MarshallingInfo<List> CLOUDWATCHLOGGINGOPTIONUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLoggingOptionUpdates").build();
    private static final ApplicationUpdateMarshaller INSTANCE = new ApplicationUpdateMarshaller();

    public static ApplicationUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ApplicationUpdate applicationUpdate, ProtocolMarshaller protocolMarshaller) {
        if (applicationUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(applicationUpdate.inputUpdates(), INPUTUPDATES_BINDING);
            protocolMarshaller.marshall((Object)applicationUpdate.applicationCodeUpdate(), APPLICATIONCODEUPDATE_BINDING);
            protocolMarshaller.marshall(applicationUpdate.outputUpdates(), OUTPUTUPDATES_BINDING);
            protocolMarshaller.marshall(applicationUpdate.referenceDataSourceUpdates(), REFERENCEDATASOURCEUPDATES_BINDING);
            protocolMarshaller.marshall(applicationUpdate.cloudWatchLoggingOptionUpdates(), CLOUDWATCHLOGGINGOPTIONUPDATES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

