/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription;

@SdkInternalApi
public class OutputDescriptionMarshaller {
    private static final MarshallingInfo<String> OUTPUTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOUTPUTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamsOutputDescription").build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEOUTPUTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisFirehoseOutputDescription").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationSchema").build();
    private static final OutputDescriptionMarshaller INSTANCE = new OutputDescriptionMarshaller();

    public static OutputDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputDescription outputDescription, ProtocolMarshaller protocolMarshaller) {
        if (outputDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)outputDescription.outputId(), OUTPUTID_BINDING);
            protocolMarshaller.marshall((Object)outputDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)outputDescription.kinesisStreamsOutputDescription(), KINESISSTREAMSOUTPUTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)outputDescription.kinesisFirehoseOutputDescription(), KINESISFIREHOSEOUTPUTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)outputDescription.destinationSchema(), DESTINATIONSCHEMA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

