/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat;

@SdkInternalApi
public class RecordFormatMarshaller {
    private static final MarshallingInfo<String> RECORDFORMATTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordFormatType").build();
    private static final MarshallingInfo<StructuredPojo> MAPPINGPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MappingParameters").build();
    private static final RecordFormatMarshaller INSTANCE = new RecordFormatMarshaller();

    public static RecordFormatMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RecordFormat recordFormat, ProtocolMarshaller protocolMarshaller) {
        if (recordFormat == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)recordFormat.recordFormatTypeString(), RECORDFORMATTYPE_BINDING);
            protocolMarshaller.marshall((Object)recordFormat.mappingParameters(), MAPPINGPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

