/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationRequest;

@SdkInternalApi
public class StartApplicationRequestModelMarshaller {
    private static final MarshallingInfo<String> APPLICATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationName").build();
    private static final MarshallingInfo<List> INPUTCONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputConfigurations").build();
    private static final StartApplicationRequestModelMarshaller INSTANCE = new StartApplicationRequestModelMarshaller();

    public static StartApplicationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StartApplicationRequest startApplicationRequest, ProtocolMarshaller protocolMarshaller) {
        if (startApplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)startApplicationRequest.applicationName(), APPLICATIONNAME_BINDING);
            protocolMarshaller.marshall(startApplicationRequest.inputConfigurations(), INPUTCONFIGURATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

