/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDeliveryStreamRequest extends FirehoseRequest implements
        ToCopyableBuilder<CreateDeliveryStreamRequest.Builder, CreateDeliveryStreamRequest> {
    private final String deliveryStreamName;

    private final String deliveryStreamType;

    private final KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration;

    private final S3DestinationConfiguration s3DestinationConfiguration;

    private final ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration;

    private final RedshiftDestinationConfiguration redshiftDestinationConfiguration;

    private final ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration;

    private final SplunkDestinationConfiguration splunkDestinationConfiguration;

    private CreateDeliveryStreamRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.deliveryStreamType = builder.deliveryStreamType;
        this.kinesisStreamSourceConfiguration = builder.kinesisStreamSourceConfiguration;
        this.s3DestinationConfiguration = builder.s3DestinationConfiguration;
        this.extendedS3DestinationConfiguration = builder.extendedS3DestinationConfiguration;
        this.redshiftDestinationConfiguration = builder.redshiftDestinationConfiguration;
        this.elasticsearchDestinationConfiguration = builder.elasticsearchDestinationConfiguration;
        this.splunkDestinationConfiguration = builder.splunkDestinationConfiguration;
    }

    /**
     * <p>
     * The name of the delivery stream. This name must be unique per AWS account in the same region. If the delivery
     * streams are in different accounts or different regions, you can have multiple delivery streams with the same
     * name.
     * </p>
     * 
     * @return The name of the delivery stream. This name must be unique per AWS account in the same region. If the
     *         delivery streams are in different accounts or different regions, you can have multiple delivery streams
     *         with the same name.
     */
    public String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * The delivery stream type. This parameter can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DirectPut</code>: Provider applications access the delivery stream directly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryStreamType} will return {@link DeliveryStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deliveryStreamTypeString}.
     * </p>
     * 
     * @return The delivery stream type. This parameter can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DirectPut</code>: Provider applications access the delivery stream directly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
     *         </p>
     *         </li>
     * @see DeliveryStreamType
     */
    public DeliveryStreamType deliveryStreamType() {
        return DeliveryStreamType.fromValue(deliveryStreamType);
    }

    /**
     * <p>
     * The delivery stream type. This parameter can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DirectPut</code>: Provider applications access the delivery stream directly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryStreamType} will return {@link DeliveryStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deliveryStreamTypeString}.
     * </p>
     * 
     * @return The delivery stream type. This parameter can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DirectPut</code>: Provider applications access the delivery stream directly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
     *         </p>
     *         </li>
     * @see DeliveryStreamType
     */
    public String deliveryStreamTypeString() {
        return deliveryStreamType;
    }

    /**
     * <p>
     * When a Kinesis stream is used as the source for the delivery stream, a <a>KinesisStreamSourceConfiguration</a>
     * containing the Kinesis stream ARN and the role ARN for the source stream.
     * </p>
     * 
     * @return When a Kinesis stream is used as the source for the delivery stream, a
     *         <a>KinesisStreamSourceConfiguration</a> containing the Kinesis stream ARN and the role ARN for the source
     *         stream.
     */
    public KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration() {
        return kinesisStreamSourceConfiguration;
    }

    /**
     * <p>
     * [Deprecated] The destination in Amazon S3. You can specify only one destination.
     * </p>
     * 
     * @return [Deprecated] The destination in Amazon S3. You can specify only one destination.
     */
    public S3DestinationConfiguration s3DestinationConfiguration() {
        return s3DestinationConfiguration;
    }

    /**
     * <p>
     * The destination in Amazon S3. You can specify only one destination.
     * </p>
     * 
     * @return The destination in Amazon S3. You can specify only one destination.
     */
    public ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration() {
        return extendedS3DestinationConfiguration;
    }

    /**
     * <p>
     * The destination in Amazon Redshift. You can specify only one destination.
     * </p>
     * 
     * @return The destination in Amazon Redshift. You can specify only one destination.
     */
    public RedshiftDestinationConfiguration redshiftDestinationConfiguration() {
        return redshiftDestinationConfiguration;
    }

    /**
     * <p>
     * The destination in Amazon ES. You can specify only one destination.
     * </p>
     * 
     * @return The destination in Amazon ES. You can specify only one destination.
     */
    public ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration() {
        return elasticsearchDestinationConfiguration;
    }

    /**
     * <p>
     * The destination in Splunk. You can specify only one destination.
     * </p>
     * 
     * @return The destination in Splunk. You can specify only one destination.
     */
    public SplunkDestinationConfiguration splunkDestinationConfiguration() {
        return splunkDestinationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3DestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(extendedS3DestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(splunkDestinationConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeliveryStreamRequest)) {
            return false;
        }
        CreateDeliveryStreamRequest other = (CreateDeliveryStreamRequest) obj;
        return Objects.equals(deliveryStreamName(), other.deliveryStreamName())
                && Objects.equals(deliveryStreamTypeString(), other.deliveryStreamTypeString())
                && Objects.equals(kinesisStreamSourceConfiguration(), other.kinesisStreamSourceConfiguration())
                && Objects.equals(s3DestinationConfiguration(), other.s3DestinationConfiguration())
                && Objects.equals(extendedS3DestinationConfiguration(), other.extendedS3DestinationConfiguration())
                && Objects.equals(redshiftDestinationConfiguration(), other.redshiftDestinationConfiguration())
                && Objects.equals(elasticsearchDestinationConfiguration(), other.elasticsearchDestinationConfiguration())
                && Objects.equals(splunkDestinationConfiguration(), other.splunkDestinationConfiguration());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(deliveryStreamName()).append(",");
        }
        if (deliveryStreamTypeString() != null) {
            sb.append("DeliveryStreamType: ").append(deliveryStreamTypeString()).append(",");
        }
        if (kinesisStreamSourceConfiguration() != null) {
            sb.append("KinesisStreamSourceConfiguration: ").append(kinesisStreamSourceConfiguration()).append(",");
        }
        if (s3DestinationConfiguration() != null) {
            sb.append("S3DestinationConfiguration: ").append(s3DestinationConfiguration()).append(",");
        }
        if (extendedS3DestinationConfiguration() != null) {
            sb.append("ExtendedS3DestinationConfiguration: ").append(extendedS3DestinationConfiguration()).append(",");
        }
        if (redshiftDestinationConfiguration() != null) {
            sb.append("RedshiftDestinationConfiguration: ").append(redshiftDestinationConfiguration()).append(",");
        }
        if (elasticsearchDestinationConfiguration() != null) {
            sb.append("ElasticsearchDestinationConfiguration: ").append(elasticsearchDestinationConfiguration()).append(",");
        }
        if (splunkDestinationConfiguration() != null) {
            sb.append("SplunkDestinationConfiguration: ").append(splunkDestinationConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamName":
            return Optional.of(clazz.cast(deliveryStreamName()));
        case "DeliveryStreamType":
            return Optional.of(clazz.cast(deliveryStreamTypeString()));
        case "KinesisStreamSourceConfiguration":
            return Optional.of(clazz.cast(kinesisStreamSourceConfiguration()));
        case "S3DestinationConfiguration":
            return Optional.of(clazz.cast(s3DestinationConfiguration()));
        case "ExtendedS3DestinationConfiguration":
            return Optional.of(clazz.cast(extendedS3DestinationConfiguration()));
        case "RedshiftDestinationConfiguration":
            return Optional.of(clazz.cast(redshiftDestinationConfiguration()));
        case "ElasticsearchDestinationConfiguration":
            return Optional.of(clazz.cast(elasticsearchDestinationConfiguration()));
        case "SplunkDestinationConfiguration":
            return Optional.of(clazz.cast(splunkDestinationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends FirehoseRequest.Builder, CopyableBuilder<Builder, CreateDeliveryStreamRequest> {
        /**
         * <p>
         * The name of the delivery stream. This name must be unique per AWS account in the same region. If the delivery
         * streams are in different accounts or different regions, you can have multiple delivery streams with the same
         * name.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream. This name must be unique per AWS account in the same region. If the
         *        delivery streams are in different accounts or different regions, you can have multiple delivery
         *        streams with the same name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * The delivery stream type. This parameter can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DirectPut</code>: Provider applications access the delivery stream directly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryStreamType
         *        The delivery stream type. This parameter can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DirectPut</code>: Provider applications access the delivery stream directly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
         *        </p>
         *        </li>
         * @see DeliveryStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStreamType
         */
        Builder deliveryStreamType(String deliveryStreamType);

        /**
         * <p>
         * The delivery stream type. This parameter can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DirectPut</code>: Provider applications access the delivery stream directly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryStreamType
         *        The delivery stream type. This parameter can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DirectPut</code>: Provider applications access the delivery stream directly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
         *        </p>
         *        </li>
         * @see DeliveryStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStreamType
         */
        Builder deliveryStreamType(DeliveryStreamType deliveryStreamType);

        /**
         * <p>
         * When a Kinesis stream is used as the source for the delivery stream, a
         * <a>KinesisStreamSourceConfiguration</a> containing the Kinesis stream ARN and the role ARN for the source
         * stream.
         * </p>
         * 
         * @param kinesisStreamSourceConfiguration
         *        When a Kinesis stream is used as the source for the delivery stream, a
         *        <a>KinesisStreamSourceConfiguration</a> containing the Kinesis stream ARN and the role ARN for the
         *        source stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration);

        /**
         * <p>
         * When a Kinesis stream is used as the source for the delivery stream, a
         * <a>KinesisStreamSourceConfiguration</a> containing the Kinesis stream ARN and the role ARN for the source
         * stream.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisStreamSourceConfiguration.Builder}
         * avoiding the need to create one manually via {@link KinesisStreamSourceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisStreamSourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration)}.
         * 
         * @param kinesisStreamSourceConfiguration
         *        a consumer that will call methods on {@link KinesisStreamSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration)
         */
        default Builder kinesisStreamSourceConfiguration(
                Consumer<KinesisStreamSourceConfiguration.Builder> kinesisStreamSourceConfiguration) {
            return kinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration.builder()
                    .apply(kinesisStreamSourceConfiguration).build());
        }

        /**
         * <p>
         * [Deprecated] The destination in Amazon S3. You can specify only one destination.
         * </p>
         * 
         * @param s3DestinationConfiguration
         *        [Deprecated] The destination in Amazon S3. You can specify only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationConfiguration(S3DestinationConfiguration s3DestinationConfiguration);

        /**
         * <p>
         * [Deprecated] The destination in Amazon S3. You can specify only one destination.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DestinationConfiguration.Builder} avoiding the
         * need to create one manually via {@link S3DestinationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3DestinationConfiguration(S3DestinationConfiguration)}.
         * 
         * @param s3DestinationConfiguration
         *        a consumer that will call methods on {@link S3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DestinationConfiguration(S3DestinationConfiguration)
         */
        default Builder s3DestinationConfiguration(Consumer<S3DestinationConfiguration.Builder> s3DestinationConfiguration) {
            return s3DestinationConfiguration(S3DestinationConfiguration.builder().apply(s3DestinationConfiguration).build());
        }

        /**
         * <p>
         * The destination in Amazon S3. You can specify only one destination.
         * </p>
         * 
         * @param extendedS3DestinationConfiguration
         *        The destination in Amazon S3. You can specify only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration);

        /**
         * <p>
         * The destination in Amazon S3. You can specify only one destination.
         * </p>
         * This is a convenience that creates an instance of the {@link ExtendedS3DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExtendedS3DestinationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExtendedS3DestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration)}.
         * 
         * @param extendedS3DestinationConfiguration
         *        a consumer that will call methods on {@link ExtendedS3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration)
         */
        default Builder extendedS3DestinationConfiguration(
                Consumer<ExtendedS3DestinationConfiguration.Builder> extendedS3DestinationConfiguration) {
            return extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration.builder()
                    .apply(extendedS3DestinationConfiguration).build());
        }

        /**
         * <p>
         * The destination in Amazon Redshift. You can specify only one destination.
         * </p>
         * 
         * @param redshiftDestinationConfiguration
         *        The destination in Amazon Redshift. You can specify only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDestinationConfiguration(RedshiftDestinationConfiguration redshiftDestinationConfiguration);

        /**
         * <p>
         * The destination in Amazon Redshift. You can specify only one destination.
         * </p>
         * This is a convenience that creates an instance of the {@link RedshiftDestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link RedshiftDestinationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RedshiftDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #redshiftDestinationConfiguration(RedshiftDestinationConfiguration)}.
         * 
         * @param redshiftDestinationConfiguration
         *        a consumer that will call methods on {@link RedshiftDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftDestinationConfiguration(RedshiftDestinationConfiguration)
         */
        default Builder redshiftDestinationConfiguration(
                Consumer<RedshiftDestinationConfiguration.Builder> redshiftDestinationConfiguration) {
            return redshiftDestinationConfiguration(RedshiftDestinationConfiguration.builder()
                    .apply(redshiftDestinationConfiguration).build());
        }

        /**
         * <p>
         * The destination in Amazon ES. You can specify only one destination.
         * </p>
         * 
         * @param elasticsearchDestinationConfiguration
         *        The destination in Amazon ES. You can specify only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration);

        /**
         * <p>
         * The destination in Amazon ES. You can specify only one destination.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticsearchDestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link ElasticsearchDestinationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticsearchDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration)}.
         * 
         * @param elasticsearchDestinationConfiguration
         *        a consumer that will call methods on {@link ElasticsearchDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration)
         */
        default Builder elasticsearchDestinationConfiguration(
                Consumer<ElasticsearchDestinationConfiguration.Builder> elasticsearchDestinationConfiguration) {
            return elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration.builder()
                    .apply(elasticsearchDestinationConfiguration).build());
        }

        /**
         * <p>
         * The destination in Splunk. You can specify only one destination.
         * </p>
         * 
         * @param splunkDestinationConfiguration
         *        The destination in Splunk. You can specify only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splunkDestinationConfiguration(SplunkDestinationConfiguration splunkDestinationConfiguration);

        /**
         * <p>
         * The destination in Splunk. You can specify only one destination.
         * </p>
         * This is a convenience that creates an instance of the {@link SplunkDestinationConfiguration.Builder} avoiding
         * the need to create one manually via {@link SplunkDestinationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SplunkDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #splunkDestinationConfiguration(SplunkDestinationConfiguration)}.
         * 
         * @param splunkDestinationConfiguration
         *        a consumer that will call methods on {@link SplunkDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #splunkDestinationConfiguration(SplunkDestinationConfiguration)
         */
        default Builder splunkDestinationConfiguration(
                Consumer<SplunkDestinationConfiguration.Builder> splunkDestinationConfiguration) {
            return splunkDestinationConfiguration(SplunkDestinationConfiguration.builder().apply(splunkDestinationConfiguration)
                    .build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends FirehoseRequest.BuilderImpl implements Builder {
        private String deliveryStreamName;

        private String deliveryStreamType;

        private KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration;

        private S3DestinationConfiguration s3DestinationConfiguration;

        private ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration;

        private RedshiftDestinationConfiguration redshiftDestinationConfiguration;

        private ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration;

        private SplunkDestinationConfiguration splunkDestinationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeliveryStreamRequest model) {
            deliveryStreamName(model.deliveryStreamName);
            deliveryStreamType(model.deliveryStreamType);
            kinesisStreamSourceConfiguration(model.kinesisStreamSourceConfiguration);
            s3DestinationConfiguration(model.s3DestinationConfiguration);
            extendedS3DestinationConfiguration(model.extendedS3DestinationConfiguration);
            redshiftDestinationConfiguration(model.redshiftDestinationConfiguration);
            elasticsearchDestinationConfiguration(model.elasticsearchDestinationConfiguration);
            splunkDestinationConfiguration(model.splunkDestinationConfiguration);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getDeliveryStreamType() {
            return deliveryStreamType;
        }

        @Override
        public final Builder deliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
            return this;
        }

        @Override
        public final Builder deliveryStreamType(DeliveryStreamType deliveryStreamType) {
            this.deliveryStreamType(deliveryStreamType.toString());
            return this;
        }

        public final void setDeliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
        }

        public final KinesisStreamSourceConfiguration.Builder getKinesisStreamSourceConfiguration() {
            return kinesisStreamSourceConfiguration != null ? kinesisStreamSourceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration) {
            this.kinesisStreamSourceConfiguration = kinesisStreamSourceConfiguration;
            return this;
        }

        public final void setKinesisStreamSourceConfiguration(
                KinesisStreamSourceConfiguration.BuilderImpl kinesisStreamSourceConfiguration) {
            this.kinesisStreamSourceConfiguration = kinesisStreamSourceConfiguration != null ? kinesisStreamSourceConfiguration
                    .build() : null;
        }

        public final S3DestinationConfiguration.Builder getS3DestinationConfiguration() {
            return s3DestinationConfiguration != null ? s3DestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationConfiguration(S3DestinationConfiguration s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration;
            return this;
        }

        public final void setS3DestinationConfiguration(S3DestinationConfiguration.BuilderImpl s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration != null ? s3DestinationConfiguration.build() : null;
        }

        public final ExtendedS3DestinationConfiguration.Builder getExtendedS3DestinationConfiguration() {
            return extendedS3DestinationConfiguration != null ? extendedS3DestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder extendedS3DestinationConfiguration(
                ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration;
            return this;
        }

        public final void setExtendedS3DestinationConfiguration(
                ExtendedS3DestinationConfiguration.BuilderImpl extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration != null ? extendedS3DestinationConfiguration
                    .build() : null;
        }

        public final RedshiftDestinationConfiguration.Builder getRedshiftDestinationConfiguration() {
            return redshiftDestinationConfiguration != null ? redshiftDestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDestinationConfiguration(RedshiftDestinationConfiguration redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration;
            return this;
        }

        public final void setRedshiftDestinationConfiguration(
                RedshiftDestinationConfiguration.BuilderImpl redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration != null ? redshiftDestinationConfiguration
                    .build() : null;
        }

        public final ElasticsearchDestinationConfiguration.Builder getElasticsearchDestinationConfiguration() {
            return elasticsearchDestinationConfiguration != null ? elasticsearchDestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchDestinationConfiguration(
                ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration;
            return this;
        }

        public final void setElasticsearchDestinationConfiguration(
                ElasticsearchDestinationConfiguration.BuilderImpl elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration != null ? elasticsearchDestinationConfiguration
                    .build() : null;
        }

        public final SplunkDestinationConfiguration.Builder getSplunkDestinationConfiguration() {
            return splunkDestinationConfiguration != null ? splunkDestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder splunkDestinationConfiguration(SplunkDestinationConfiguration splunkDestinationConfiguration) {
            this.splunkDestinationConfiguration = splunkDestinationConfiguration;
            return this;
        }

        public final void setSplunkDestinationConfiguration(
                SplunkDestinationConfiguration.BuilderImpl splunkDestinationConfiguration) {
            this.splunkDestinationConfiguration = splunkDestinationConfiguration != null ? splunkDestinationConfiguration.build()
                    : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDeliveryStreamRequest build() {
            return new CreateDeliveryStreamRequest(this);
        }
    }
}
