/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteDeliveryStreamRequest extends FirehoseRequest implements
        ToCopyableBuilder<DeleteDeliveryStreamRequest.Builder, DeleteDeliveryStreamRequest> {
    private final String deliveryStreamName;

    private DeleteDeliveryStreamRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
    }

    /**
     * <p>
     * The name of the delivery stream.
     * </p>
     * 
     * @return The name of the delivery stream.
     */
    public String deliveryStreamName() {
        return deliveryStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDeliveryStreamRequest)) {
            return false;
        }
        DeleteDeliveryStreamRequest other = (DeleteDeliveryStreamRequest) obj;
        return Objects.equals(deliveryStreamName(), other.deliveryStreamName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(deliveryStreamName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamName":
            return Optional.of(clazz.cast(deliveryStreamName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends FirehoseRequest.Builder, CopyableBuilder<Builder, DeleteDeliveryStreamRequest> {
        /**
         * <p>
         * The name of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends FirehoseRequest.BuilderImpl implements Builder {
        private String deliveryStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDeliveryStreamRequest model) {
            deliveryStreamName(model.deliveryStreamName);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteDeliveryStreamRequest build() {
            return new DeleteDeliveryStreamRequest(this);
        }
    }
}
