/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDeliveryStreamsRequest extends FirehoseRequest implements
        ToCopyableBuilder<ListDeliveryStreamsRequest.Builder, ListDeliveryStreamsRequest> {
    private final Integer limit;

    private final String deliveryStreamType;

    private final String exclusiveStartDeliveryStreamName;

    private ListDeliveryStreamsRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.deliveryStreamType = builder.deliveryStreamType;
        this.exclusiveStartDeliveryStreamName = builder.exclusiveStartDeliveryStreamName;
    }

    /**
     * <p>
     * The maximum number of delivery streams to list. The default value is 10.
     * </p>
     * 
     * @return The maximum number of delivery streams to list. The default value is 10.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The delivery stream type. This can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DirectPut</code>: Provider applications access the delivery stream directly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryStreamType} will return {@link DeliveryStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deliveryStreamTypeString}.
     * </p>
     * 
     * @return The delivery stream type. This can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DirectPut</code>: Provider applications access the delivery stream directly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
     * @see DeliveryStreamType
     */
    public DeliveryStreamType deliveryStreamType() {
        return DeliveryStreamType.fromValue(deliveryStreamType);
    }

    /**
     * <p>
     * The delivery stream type. This can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DirectPut</code>: Provider applications access the delivery stream directly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryStreamType} will return {@link DeliveryStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deliveryStreamTypeString}.
     * </p>
     * 
     * @return The delivery stream type. This can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DirectPut</code>: Provider applications access the delivery stream directly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
     * @see DeliveryStreamType
     */
    public String deliveryStreamTypeString() {
        return deliveryStreamType;
    }

    /**
     * <p>
     * The name of the delivery stream to start the list with.
     * </p>
     * 
     * @return The name of the delivery stream to start the list with.
     */
    public String exclusiveStartDeliveryStreamName() {
        return exclusiveStartDeliveryStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartDeliveryStreamName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeliveryStreamsRequest)) {
            return false;
        }
        ListDeliveryStreamsRequest other = (ListDeliveryStreamsRequest) obj;
        return Objects.equals(limit(), other.limit())
                && Objects.equals(deliveryStreamTypeString(), other.deliveryStreamTypeString())
                && Objects.equals(exclusiveStartDeliveryStreamName(), other.exclusiveStartDeliveryStreamName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (deliveryStreamTypeString() != null) {
            sb.append("DeliveryStreamType: ").append(deliveryStreamTypeString()).append(",");
        }
        if (exclusiveStartDeliveryStreamName() != null) {
            sb.append("ExclusiveStartDeliveryStreamName: ").append(exclusiveStartDeliveryStreamName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Limit":
            return Optional.of(clazz.cast(limit()));
        case "DeliveryStreamType":
            return Optional.of(clazz.cast(deliveryStreamTypeString()));
        case "ExclusiveStartDeliveryStreamName":
            return Optional.of(clazz.cast(exclusiveStartDeliveryStreamName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends FirehoseRequest.Builder, CopyableBuilder<Builder, ListDeliveryStreamsRequest> {
        /**
         * <p>
         * The maximum number of delivery streams to list. The default value is 10.
         * </p>
         * 
         * @param limit
         *        The maximum number of delivery streams to list. The default value is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The delivery stream type. This can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DirectPut</code>: Provider applications access the delivery stream directly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
         * </p>
         * 
         * @param deliveryStreamType
         *        The delivery stream type. This can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DirectPut</code>: Provider applications access the delivery stream directly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
         * @see DeliveryStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStreamType
         */
        Builder deliveryStreamType(String deliveryStreamType);

        /**
         * <p>
         * The delivery stream type. This can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DirectPut</code>: Provider applications access the delivery stream directly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
         * </p>
         * 
         * @param deliveryStreamType
         *        The delivery stream type. This can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DirectPut</code>: Provider applications access the delivery stream directly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis stream as a source.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
         * @see DeliveryStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStreamType
         */
        Builder deliveryStreamType(DeliveryStreamType deliveryStreamType);

        /**
         * <p>
         * The name of the delivery stream to start the list with.
         * </p>
         * 
         * @param exclusiveStartDeliveryStreamName
         *        The name of the delivery stream to start the list with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartDeliveryStreamName(String exclusiveStartDeliveryStreamName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends FirehoseRequest.BuilderImpl implements Builder {
        private Integer limit;

        private String deliveryStreamType;

        private String exclusiveStartDeliveryStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeliveryStreamsRequest model) {
            limit(model.limit);
            deliveryStreamType(model.deliveryStreamType);
            exclusiveStartDeliveryStreamName(model.exclusiveStartDeliveryStreamName);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getDeliveryStreamType() {
            return deliveryStreamType;
        }

        @Override
        public final Builder deliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
            return this;
        }

        @Override
        public final Builder deliveryStreamType(DeliveryStreamType deliveryStreamType) {
            this.deliveryStreamType(deliveryStreamType.toString());
            return this;
        }

        public final void setDeliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
        }

        public final String getExclusiveStartDeliveryStreamName() {
            return exclusiveStartDeliveryStreamName;
        }

        @Override
        public final Builder exclusiveStartDeliveryStreamName(String exclusiveStartDeliveryStreamName) {
            this.exclusiveStartDeliveryStreamName = exclusiveStartDeliveryStreamName;
            return this;
        }

        public final void setExclusiveStartDeliveryStreamName(String exclusiveStartDeliveryStreamName) {
            this.exclusiveStartDeliveryStreamName = exclusiveStartDeliveryStreamName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListDeliveryStreamsRequest build() {
            return new ListDeliveryStreamsRequest(this);
        }
    }
}
