/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.SplunkDestinationUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an update for a destination in Splunk.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SplunkDestinationUpdate implements StructuredPojo,
        ToCopyableBuilder<SplunkDestinationUpdate.Builder, SplunkDestinationUpdate> {
    private final String hecEndpoint;

    private final String hecEndpointType;

    private final String hecToken;

    private final Integer hecAcknowledgmentTimeoutInSeconds;

    private final SplunkRetryOptions retryOptions;

    private final String s3BackupMode;

    private final S3DestinationUpdate s3Update;

    private final ProcessingConfiguration processingConfiguration;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private SplunkDestinationUpdate(BuilderImpl builder) {
        this.hecEndpoint = builder.hecEndpoint;
        this.hecEndpointType = builder.hecEndpointType;
        this.hecToken = builder.hecToken;
        this.hecAcknowledgmentTimeoutInSeconds = builder.hecAcknowledgmentTimeoutInSeconds;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Update = builder.s3Update;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * The HTTP Event Collector (HEC) endpoint to which Kinesis Firehose sends your data.
     * </p>
     * 
     * @return The HTTP Event Collector (HEC) endpoint to which Kinesis Firehose sends your data.
     */
    public String hecEndpoint() {
        return hecEndpoint;
    }

    /**
     * <p>
     * This type can be either "Raw" or "Event".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hecEndpointType}
     * will return {@link HECEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hecEndpointTypeString}.
     * </p>
     * 
     * @return This type can be either "Raw" or "Event".
     * @see HECEndpointType
     */
    public HECEndpointType hecEndpointType() {
        return HECEndpointType.fromValue(hecEndpointType);
    }

    /**
     * <p>
     * This type can be either "Raw" or "Event".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hecEndpointType}
     * will return {@link HECEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hecEndpointTypeString}.
     * </p>
     * 
     * @return This type can be either "Raw" or "Event".
     * @see HECEndpointType
     */
    public String hecEndpointTypeString() {
        return hecEndpointType;
    }

    /**
     * <p>
     * This is a GUID you obtain from your Splunk cluster when you create a new HEC endpoint.
     * </p>
     * 
     * @return This is a GUID you obtain from your Splunk cluster when you create a new HEC endpoint.
     */
    public String hecToken() {
        return hecToken;
    }

    /**
     * <p>
     * The amount of time that Kinesis Firehose waits to receive an acknowledgment from Splunk after it sends it data.
     * At the end of the timeout period Kinesis Firehose either tries to send the data again or considers it an error,
     * based on your retry settings.
     * </p>
     * 
     * @return The amount of time that Kinesis Firehose waits to receive an acknowledgment from Splunk after it sends it
     *         data. At the end of the timeout period Kinesis Firehose either tries to send the data again or considers
     *         it an error, based on your retry settings.
     */
    public Integer hecAcknowledgmentTimeoutInSeconds() {
        return hecAcknowledgmentTimeoutInSeconds;
    }

    /**
     * <p>
     * The retry behavior in case Kinesis Firehose is unable to deliver data to Splunk or if it doesn't receive an
     * acknowledgment of receipt from Splunk.
     * </p>
     * 
     * @return The retry behavior in case Kinesis Firehose is unable to deliver data to Splunk or if it doesn't receive
     *         an acknowledgment of receipt from Splunk.
     */
    public SplunkRetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * <p>
     * Defines how documents should be delivered to Amazon S3. When set to <code>FailedDocumentsOnly</code>, Kinesis
     * Firehose writes any data that could not be indexed to the configured Amazon S3 destination. When set to
     * <code>AllDocuments</code>, Kinesis Firehose delivers all incoming records to Amazon S3, and also writes failed
     * documents to Amazon S3. Default value is <code>FailedDocumentsOnly</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link SplunkS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3BackupModeString}.
     * </p>
     * 
     * @return Defines how documents should be delivered to Amazon S3. When set to <code>FailedDocumentsOnly</code>,
     *         Kinesis Firehose writes any data that could not be indexed to the configured Amazon S3 destination. When
     *         set to <code>AllDocuments</code>, Kinesis Firehose delivers all incoming records to Amazon S3, and also
     *         writes failed documents to Amazon S3. Default value is <code>FailedDocumentsOnly</code>.
     * @see SplunkS3BackupMode
     */
    public SplunkS3BackupMode s3BackupMode() {
        return SplunkS3BackupMode.fromValue(s3BackupMode);
    }

    /**
     * <p>
     * Defines how documents should be delivered to Amazon S3. When set to <code>FailedDocumentsOnly</code>, Kinesis
     * Firehose writes any data that could not be indexed to the configured Amazon S3 destination. When set to
     * <code>AllDocuments</code>, Kinesis Firehose delivers all incoming records to Amazon S3, and also writes failed
     * documents to Amazon S3. Default value is <code>FailedDocumentsOnly</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link SplunkS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3BackupModeString}.
     * </p>
     * 
     * @return Defines how documents should be delivered to Amazon S3. When set to <code>FailedDocumentsOnly</code>,
     *         Kinesis Firehose writes any data that could not be indexed to the configured Amazon S3 destination. When
     *         set to <code>AllDocuments</code>, Kinesis Firehose delivers all incoming records to Amazon S3, and also
     *         writes failed documents to Amazon S3. Default value is <code>FailedDocumentsOnly</code>.
     * @see SplunkS3BackupMode
     */
    public String s3BackupModeString() {
        return s3BackupMode;
    }

    /**
     * <p>
     * Your update to the configuration of the backup Amazon S3 location.
     * </p>
     * 
     * @return Your update to the configuration of the backup Amazon S3 location.
     */
    public S3DestinationUpdate s3Update() {
        return s3Update;
    }

    /**
     * <p>
     * The data processing configuration.
     * </p>
     * 
     * @return The data processing configuration.
     */
    public ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * <p>
     * The CloudWatch logging options for your delivery stream.
     * </p>
     * 
     * @return The CloudWatch logging options for your delivery stream.
     */
    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hecEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(hecEndpointTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(hecToken());
        hashCode = 31 * hashCode + Objects.hashCode(hecAcknowledgmentTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(s3BackupModeString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Update());
        hashCode = 31 * hashCode + Objects.hashCode(processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SplunkDestinationUpdate)) {
            return false;
        }
        SplunkDestinationUpdate other = (SplunkDestinationUpdate) obj;
        return Objects.equals(hecEndpoint(), other.hecEndpoint())
                && Objects.equals(hecEndpointTypeString(), other.hecEndpointTypeString())
                && Objects.equals(hecToken(), other.hecToken())
                && Objects.equals(hecAcknowledgmentTimeoutInSeconds(), other.hecAcknowledgmentTimeoutInSeconds())
                && Objects.equals(retryOptions(), other.retryOptions())
                && Objects.equals(s3BackupModeString(), other.s3BackupModeString())
                && Objects.equals(s3Update(), other.s3Update())
                && Objects.equals(processingConfiguration(), other.processingConfiguration())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (hecEndpoint() != null) {
            sb.append("HECEndpoint: ").append(hecEndpoint()).append(",");
        }
        if (hecEndpointTypeString() != null) {
            sb.append("HECEndpointType: ").append(hecEndpointTypeString()).append(",");
        }
        if (hecToken() != null) {
            sb.append("HECToken: ").append(hecToken()).append(",");
        }
        if (hecAcknowledgmentTimeoutInSeconds() != null) {
            sb.append("HECAcknowledgmentTimeoutInSeconds: ").append(hecAcknowledgmentTimeoutInSeconds()).append(",");
        }
        if (retryOptions() != null) {
            sb.append("RetryOptions: ").append(retryOptions()).append(",");
        }
        if (s3BackupModeString() != null) {
            sb.append("S3BackupMode: ").append(s3BackupModeString()).append(",");
        }
        if (s3Update() != null) {
            sb.append("S3Update: ").append(s3Update()).append(",");
        }
        if (processingConfiguration() != null) {
            sb.append("ProcessingConfiguration: ").append(processingConfiguration()).append(",");
        }
        if (cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(cloudWatchLoggingOptions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HECEndpoint":
            return Optional.of(clazz.cast(hecEndpoint()));
        case "HECEndpointType":
            return Optional.of(clazz.cast(hecEndpointTypeString()));
        case "HECToken":
            return Optional.of(clazz.cast(hecToken()));
        case "HECAcknowledgmentTimeoutInSeconds":
            return Optional.of(clazz.cast(hecAcknowledgmentTimeoutInSeconds()));
        case "RetryOptions":
            return Optional.of(clazz.cast(retryOptions()));
        case "S3BackupMode":
            return Optional.of(clazz.cast(s3BackupModeString()));
        case "S3Update":
            return Optional.of(clazz.cast(s3Update()));
        case "ProcessingConfiguration":
            return Optional.of(clazz.cast(processingConfiguration()));
        case "CloudWatchLoggingOptions":
            return Optional.of(clazz.cast(cloudWatchLoggingOptions()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SplunkDestinationUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SplunkDestinationUpdate> {
        /**
         * <p>
         * The HTTP Event Collector (HEC) endpoint to which Kinesis Firehose sends your data.
         * </p>
         * 
         * @param hecEndpoint
         *        The HTTP Event Collector (HEC) endpoint to which Kinesis Firehose sends your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hecEndpoint(String hecEndpoint);

        /**
         * <p>
         * This type can be either "Raw" or "Event".
         * </p>
         * 
         * @param hecEndpointType
         *        This type can be either "Raw" or "Event".
         * @see HECEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HECEndpointType
         */
        Builder hecEndpointType(String hecEndpointType);

        /**
         * <p>
         * This type can be either "Raw" or "Event".
         * </p>
         * 
         * @param hecEndpointType
         *        This type can be either "Raw" or "Event".
         * @see HECEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HECEndpointType
         */
        Builder hecEndpointType(HECEndpointType hecEndpointType);

        /**
         * <p>
         * This is a GUID you obtain from your Splunk cluster when you create a new HEC endpoint.
         * </p>
         * 
         * @param hecToken
         *        This is a GUID you obtain from your Splunk cluster when you create a new HEC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hecToken(String hecToken);

        /**
         * <p>
         * The amount of time that Kinesis Firehose waits to receive an acknowledgment from Splunk after it sends it
         * data. At the end of the timeout period Kinesis Firehose either tries to send the data again or considers it
         * an error, based on your retry settings.
         * </p>
         * 
         * @param hecAcknowledgmentTimeoutInSeconds
         *        The amount of time that Kinesis Firehose waits to receive an acknowledgment from Splunk after it sends
         *        it data. At the end of the timeout period Kinesis Firehose either tries to send the data again or
         *        considers it an error, based on your retry settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hecAcknowledgmentTimeoutInSeconds(Integer hecAcknowledgmentTimeoutInSeconds);

        /**
         * <p>
         * The retry behavior in case Kinesis Firehose is unable to deliver data to Splunk or if it doesn't receive an
         * acknowledgment of receipt from Splunk.
         * </p>
         * 
         * @param retryOptions
         *        The retry behavior in case Kinesis Firehose is unable to deliver data to Splunk or if it doesn't
         *        receive an acknowledgment of receipt from Splunk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(SplunkRetryOptions retryOptions);

        /**
         * <p>
         * The retry behavior in case Kinesis Firehose is unable to deliver data to Splunk or if it doesn't receive an
         * acknowledgment of receipt from Splunk.
         * </p>
         * This is a convenience that creates an instance of the {@link SplunkRetryOptions.Builder} avoiding the need to
         * create one manually via {@link SplunkRetryOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link SplunkRetryOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #retryOptions(SplunkRetryOptions)}.
         * 
         * @param retryOptions
         *        a consumer that will call methods on {@link SplunkRetryOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryOptions(SplunkRetryOptions)
         */
        default Builder retryOptions(Consumer<SplunkRetryOptions.Builder> retryOptions) {
            return retryOptions(SplunkRetryOptions.builder().apply(retryOptions).build());
        }

        /**
         * <p>
         * Defines how documents should be delivered to Amazon S3. When set to <code>FailedDocumentsOnly</code>, Kinesis
         * Firehose writes any data that could not be indexed to the configured Amazon S3 destination. When set to
         * <code>AllDocuments</code>, Kinesis Firehose delivers all incoming records to Amazon S3, and also writes
         * failed documents to Amazon S3. Default value is <code>FailedDocumentsOnly</code>.
         * </p>
         * 
         * @param s3BackupMode
         *        Defines how documents should be delivered to Amazon S3. When set to <code>FailedDocumentsOnly</code>,
         *        Kinesis Firehose writes any data that could not be indexed to the configured Amazon S3 destination.
         *        When set to <code>AllDocuments</code>, Kinesis Firehose delivers all incoming records to Amazon S3,
         *        and also writes failed documents to Amazon S3. Default value is <code>FailedDocumentsOnly</code>.
         * @see SplunkS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SplunkS3BackupMode
         */
        Builder s3BackupMode(String s3BackupMode);

        /**
         * <p>
         * Defines how documents should be delivered to Amazon S3. When set to <code>FailedDocumentsOnly</code>, Kinesis
         * Firehose writes any data that could not be indexed to the configured Amazon S3 destination. When set to
         * <code>AllDocuments</code>, Kinesis Firehose delivers all incoming records to Amazon S3, and also writes
         * failed documents to Amazon S3. Default value is <code>FailedDocumentsOnly</code>.
         * </p>
         * 
         * @param s3BackupMode
         *        Defines how documents should be delivered to Amazon S3. When set to <code>FailedDocumentsOnly</code>,
         *        Kinesis Firehose writes any data that could not be indexed to the configured Amazon S3 destination.
         *        When set to <code>AllDocuments</code>, Kinesis Firehose delivers all incoming records to Amazon S3,
         *        and also writes failed documents to Amazon S3. Default value is <code>FailedDocumentsOnly</code>.
         * @see SplunkS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SplunkS3BackupMode
         */
        Builder s3BackupMode(SplunkS3BackupMode s3BackupMode);

        /**
         * <p>
         * Your update to the configuration of the backup Amazon S3 location.
         * </p>
         * 
         * @param s3Update
         *        Your update to the configuration of the backup Amazon S3 location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Update(S3DestinationUpdate s3Update);

        /**
         * <p>
         * Your update to the configuration of the backup Amazon S3 location.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DestinationUpdate.Builder} avoiding the need
         * to create one manually via {@link S3DestinationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DestinationUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Update(S3DestinationUpdate)}.
         * 
         * @param s3Update
         *        a consumer that will call methods on {@link S3DestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Update(S3DestinationUpdate)
         */
        default Builder s3Update(Consumer<S3DestinationUpdate.Builder> s3Update) {
            return s3Update(S3DestinationUpdate.builder().apply(s3Update).build());
        }

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * 
         * @param processingConfiguration
         *        The data processing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingConfiguration.Builder} avoiding the
         * need to create one manually via {@link ProcessingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #processingConfiguration(ProcessingConfiguration)}.
         * 
         * @param processingConfiguration
         *        a consumer that will call methods on {@link ProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingConfiguration(ProcessingConfiguration)
         */
        default Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return processingConfiguration(ProcessingConfiguration.builder().apply(processingConfiguration).build());
        }

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        The CloudWatch logging options for your delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchLoggingOptions.Builder} avoiding the
         * need to create one manually via {@link CloudWatchLoggingOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOptions(CloudWatchLoggingOptions)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link CloudWatchLoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(CloudWatchLoggingOptions)
         */
        default Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return cloudWatchLoggingOptions(CloudWatchLoggingOptions.builder().apply(cloudWatchLoggingOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String hecEndpoint;

        private String hecEndpointType;

        private String hecToken;

        private Integer hecAcknowledgmentTimeoutInSeconds;

        private SplunkRetryOptions retryOptions;

        private String s3BackupMode;

        private S3DestinationUpdate s3Update;

        private ProcessingConfiguration processingConfiguration;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SplunkDestinationUpdate model) {
            hecEndpoint(model.hecEndpoint);
            hecEndpointType(model.hecEndpointType);
            hecToken(model.hecToken);
            hecAcknowledgmentTimeoutInSeconds(model.hecAcknowledgmentTimeoutInSeconds);
            retryOptions(model.retryOptions);
            s3BackupMode(model.s3BackupMode);
            s3Update(model.s3Update);
            processingConfiguration(model.processingConfiguration);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getHECEndpoint() {
            return hecEndpoint;
        }

        @Override
        public final Builder hecEndpoint(String hecEndpoint) {
            this.hecEndpoint = hecEndpoint;
            return this;
        }

        public final void setHECEndpoint(String hecEndpoint) {
            this.hecEndpoint = hecEndpoint;
        }

        public final String getHECEndpointType() {
            return hecEndpointType;
        }

        @Override
        public final Builder hecEndpointType(String hecEndpointType) {
            this.hecEndpointType = hecEndpointType;
            return this;
        }

        @Override
        public final Builder hecEndpointType(HECEndpointType hecEndpointType) {
            this.hecEndpointType(hecEndpointType.toString());
            return this;
        }

        public final void setHECEndpointType(String hecEndpointType) {
            this.hecEndpointType = hecEndpointType;
        }

        public final String getHECToken() {
            return hecToken;
        }

        @Override
        public final Builder hecToken(String hecToken) {
            this.hecToken = hecToken;
            return this;
        }

        public final void setHECToken(String hecToken) {
            this.hecToken = hecToken;
        }

        public final Integer getHECAcknowledgmentTimeoutInSeconds() {
            return hecAcknowledgmentTimeoutInSeconds;
        }

        @Override
        public final Builder hecAcknowledgmentTimeoutInSeconds(Integer hecAcknowledgmentTimeoutInSeconds) {
            this.hecAcknowledgmentTimeoutInSeconds = hecAcknowledgmentTimeoutInSeconds;
            return this;
        }

        public final void setHECAcknowledgmentTimeoutInSeconds(Integer hecAcknowledgmentTimeoutInSeconds) {
            this.hecAcknowledgmentTimeoutInSeconds = hecAcknowledgmentTimeoutInSeconds;
        }

        public final SplunkRetryOptions.Builder getRetryOptions() {
            return retryOptions != null ? retryOptions.toBuilder() : null;
        }

        @Override
        public final Builder retryOptions(SplunkRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(SplunkRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        public final String getS3BackupMode() {
            return s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(SplunkS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationUpdate.Builder getS3Update() {
            return s3Update != null ? s3Update.toBuilder() : null;
        }

        @Override
        public final Builder s3Update(S3DestinationUpdate s3Update) {
            this.s3Update = s3Update;
            return this;
        }

        public final void setS3Update(S3DestinationUpdate.BuilderImpl s3Update) {
            this.s3Update = s3Update != null ? s3Update.build() : null;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return processingConfiguration != null ? processingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public SplunkDestinationUpdate build() {
            return new SplunkDestinationUpdate(this);
        }
    }
}
