/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <code>DescribeStream</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStreamResponse extends KinesisResponse implements
        ToCopyableBuilder<DescribeStreamResponse.Builder, DescribeStreamResponse> {
    private final StreamDescription streamDescription;

    private DescribeStreamResponse(BuilderImpl builder) {
        super(builder);
        this.streamDescription = builder.streamDescription;
    }

    /**
     * <p>
     * The current status of the stream, the stream ARN, an array of shard objects that comprise the stream, and whether
     * there are more shards available.
     * </p>
     * 
     * @return The current status of the stream, the stream ARN, an array of shard objects that comprise the stream, and
     *         whether there are more shards available.
     */
    public StreamDescription streamDescription() {
        return streamDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamResponse)) {
            return false;
        }
        DescribeStreamResponse other = (DescribeStreamResponse) obj;
        return Objects.equals(streamDescription(), other.streamDescription());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (streamDescription() != null) {
            sb.append("StreamDescription: ").append(streamDescription()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamDescription":
            return Optional.of(clazz.cast(streamDescription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisResponse.Builder, CopyableBuilder<Builder, DescribeStreamResponse> {
        /**
         * <p>
         * The current status of the stream, the stream ARN, an array of shard objects that comprise the stream, and
         * whether there are more shards available.
         * </p>
         * 
         * @param streamDescription
         *        The current status of the stream, the stream ARN, an array of shard objects that comprise the stream,
         *        and whether there are more shards available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamDescription(StreamDescription streamDescription);

        /**
         * <p>
         * The current status of the stream, the stream ARN, an array of shard objects that comprise the stream, and
         * whether there are more shards available.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamDescription.Builder} avoiding the need to
         * create one manually via {@link StreamDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #streamDescription(StreamDescription)}.
         * 
         * @param streamDescription
         *        a consumer that will call methods on {@link StreamDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamDescription(StreamDescription)
         */
        default Builder streamDescription(Consumer<StreamDescription.Builder> streamDescription) {
            return streamDescription(StreamDescription.builder().apply(streamDescription).build());
        }
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private StreamDescription streamDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamResponse model) {
            streamDescription(model.streamDescription);
        }

        public final StreamDescription.Builder getStreamDescription() {
            return streamDescription != null ? streamDescription.toBuilder() : null;
        }

        @Override
        public final Builder streamDescription(StreamDescription streamDescription) {
            this.streamDescription = streamDescription;
            return this;
        }

        public final void setStreamDescription(StreamDescription.BuilderImpl streamDescription) {
            this.streamDescription = streamDescription != null ? streamDescription.build() : null;
        }

        @Override
        public DescribeStreamResponse build() {
            return new DescribeStreamResponse(this);
        }
    }
}
