/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStreamSummaryResponse extends KinesisResponse implements
        ToCopyableBuilder<DescribeStreamSummaryResponse.Builder, DescribeStreamSummaryResponse> {
    private final StreamDescriptionSummary streamDescriptionSummary;

    private DescribeStreamSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.streamDescriptionSummary = builder.streamDescriptionSummary;
    }

    /**
     * <p>
     * A <a>StreamDescriptionSummary</a> containing information about the stream.
     * </p>
     * 
     * @return A <a>StreamDescriptionSummary</a> containing information about the stream.
     */
    public StreamDescriptionSummary streamDescriptionSummary() {
        return streamDescriptionSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamDescriptionSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamSummaryResponse)) {
            return false;
        }
        DescribeStreamSummaryResponse other = (DescribeStreamSummaryResponse) obj;
        return Objects.equals(streamDescriptionSummary(), other.streamDescriptionSummary());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (streamDescriptionSummary() != null) {
            sb.append("StreamDescriptionSummary: ").append(streamDescriptionSummary()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamDescriptionSummary":
            return Optional.of(clazz.cast(streamDescriptionSummary()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisResponse.Builder, CopyableBuilder<Builder, DescribeStreamSummaryResponse> {
        /**
         * <p>
         * A <a>StreamDescriptionSummary</a> containing information about the stream.
         * </p>
         * 
         * @param streamDescriptionSummary
         *        A <a>StreamDescriptionSummary</a> containing information about the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamDescriptionSummary(StreamDescriptionSummary streamDescriptionSummary);

        /**
         * <p>
         * A <a>StreamDescriptionSummary</a> containing information about the stream.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamDescriptionSummary.Builder} avoiding the
         * need to create one manually via {@link StreamDescriptionSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamDescriptionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #streamDescriptionSummary(StreamDescriptionSummary)}.
         * 
         * @param streamDescriptionSummary
         *        a consumer that will call methods on {@link StreamDescriptionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamDescriptionSummary(StreamDescriptionSummary)
         */
        default Builder streamDescriptionSummary(Consumer<StreamDescriptionSummary.Builder> streamDescriptionSummary) {
            return streamDescriptionSummary(StreamDescriptionSummary.builder().apply(streamDescriptionSummary).build());
        }
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private StreamDescriptionSummary streamDescriptionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamSummaryResponse model) {
            streamDescriptionSummary(model.streamDescriptionSummary);
        }

        public final StreamDescriptionSummary.Builder getStreamDescriptionSummary() {
            return streamDescriptionSummary != null ? streamDescriptionSummary.toBuilder() : null;
        }

        @Override
        public final Builder streamDescriptionSummary(StreamDescriptionSummary streamDescriptionSummary) {
            this.streamDescriptionSummary = streamDescriptionSummary;
            return this;
        }

        public final void setStreamDescriptionSummary(StreamDescriptionSummary.BuilderImpl streamDescriptionSummary) {
            this.streamDescriptionSummary = streamDescriptionSummary != null ? streamDescriptionSummary.build() : null;
        }

        @Override
        public DescribeStreamSummaryResponse build() {
            return new DescribeStreamSummaryResponse(this);
        }
    }
}
