/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <code>PutRecord</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PutRecordResponse extends KinesisResponse implements ToCopyableBuilder<PutRecordResponse.Builder, PutRecordResponse> {
    private final String shardId;

    private final String sequenceNumber;

    private final String encryptionType;

    private PutRecordResponse(BuilderImpl builder) {
        super(builder);
        this.shardId = builder.shardId;
        this.sequenceNumber = builder.sequenceNumber;
        this.encryptionType = builder.encryptionType;
    }

    /**
     * <p>
     * The shard ID of the shard where the data record was placed.
     * </p>
     * 
     * @return The shard ID of the shard where the data record was placed.
     */
    public String shardId() {
        return shardId;
    }

    /**
     * <p>
     * The sequence number identifier that was assigned to the put data record. The sequence number for the record is
     * unique across all records in the stream. A sequence number is the identifier associated with every record put
     * into the stream.
     * </p>
     * 
     * @return The sequence number identifier that was assigned to the put data record. The sequence number for the
     *         record is unique across all records in the stream. A sequence number is the identifier associated with
     *         every record put into the stream.
     */
    public String sequenceNumber() {
        return sequenceNumber;
    }

    /**
     * <p>
     * The encryption type to use on the record. This parameter can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: Do not encrypt the records in the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed KMS key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeString}.
     * </p>
     * 
     * @return The encryption type to use on the record. This parameter can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Do not encrypt the records in the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed KMS
     *         key.
     *         </p>
     *         </li>
     * @see EncryptionType
     */
    public EncryptionType encryptionType() {
        return EncryptionType.fromValue(encryptionType);
    }

    /**
     * <p>
     * The encryption type to use on the record. This parameter can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: Do not encrypt the records in the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed KMS key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeString}.
     * </p>
     * 
     * @return The encryption type to use on the record. This parameter can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Do not encrypt the records in the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed KMS
     *         key.
     *         </p>
     *         </li>
     * @see EncryptionType
     */
    public String encryptionTypeString() {
        return encryptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shardId());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordResponse)) {
            return false;
        }
        PutRecordResponse other = (PutRecordResponse) obj;
        return Objects.equals(shardId(), other.shardId()) && Objects.equals(sequenceNumber(), other.sequenceNumber())
                && Objects.equals(encryptionTypeString(), other.encryptionTypeString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (shardId() != null) {
            sb.append("ShardId: ").append(shardId()).append(",");
        }
        if (sequenceNumber() != null) {
            sb.append("SequenceNumber: ").append(sequenceNumber()).append(",");
        }
        if (encryptionTypeString() != null) {
            sb.append("EncryptionType: ").append(encryptionTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardId":
            return Optional.of(clazz.cast(shardId()));
        case "SequenceNumber":
            return Optional.of(clazz.cast(sequenceNumber()));
        case "EncryptionType":
            return Optional.of(clazz.cast(encryptionTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisResponse.Builder, CopyableBuilder<Builder, PutRecordResponse> {
        /**
         * <p>
         * The shard ID of the shard where the data record was placed.
         * </p>
         * 
         * @param shardId
         *        The shard ID of the shard where the data record was placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * <p>
         * The sequence number identifier that was assigned to the put data record. The sequence number for the record
         * is unique across all records in the stream. A sequence number is the identifier associated with every record
         * put into the stream.
         * </p>
         * 
         * @param sequenceNumber
         *        The sequence number identifier that was assigned to the put data record. The sequence number for the
         *        record is unique across all records in the stream. A sequence number is the identifier associated with
         *        every record put into the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(String sequenceNumber);

        /**
         * <p>
         * The encryption type to use on the record. This parameter can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: Do not encrypt the records in the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed KMS key.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionType
         *        The encryption type to use on the record. This parameter can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Do not encrypt the records in the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed KMS
         *        key.
         *        </p>
         *        </li>
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(String encryptionType);

        /**
         * <p>
         * The encryption type to use on the record. This parameter can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: Do not encrypt the records in the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed KMS key.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionType
         *        The encryption type to use on the record. This parameter can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Do not encrypt the records in the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed KMS
         *        key.
         *        </p>
         *        </li>
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(EncryptionType encryptionType);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private String shardId;

        private String sequenceNumber;

        private String encryptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordResponse model) {
            shardId(model.shardId);
            sequenceNumber(model.sequenceNumber);
            encryptionType(model.encryptionType);
        }

        public final String getShardId() {
            return shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getSequenceNumber() {
            return sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public PutRecordResponse build() {
            return new PutRecordResponse(this);
        }
    }
}
