/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateShardCountResponse extends KinesisResponse implements
        ToCopyableBuilder<UpdateShardCountResponse.Builder, UpdateShardCountResponse> {
    private final String streamName;

    private final Integer currentShardCount;

    private final Integer targetShardCount;

    private UpdateShardCountResponse(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.currentShardCount = builder.currentShardCount;
        this.targetShardCount = builder.targetShardCount;
    }

    /**
     * <p>
     * The name of the stream.
     * </p>
     * 
     * @return The name of the stream.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The current number of shards.
     * </p>
     * 
     * @return The current number of shards.
     */
    public Integer currentShardCount() {
        return currentShardCount;
    }

    /**
     * <p>
     * The updated number of shards.
     * </p>
     * 
     * @return The updated number of shards.
     */
    public Integer targetShardCount() {
        return targetShardCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(currentShardCount());
        hashCode = 31 * hashCode + Objects.hashCode(targetShardCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateShardCountResponse)) {
            return false;
        }
        UpdateShardCountResponse other = (UpdateShardCountResponse) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(currentShardCount(), other.currentShardCount())
                && Objects.equals(targetShardCount(), other.targetShardCount());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (streamName() != null) {
            sb.append("StreamName: ").append(streamName()).append(",");
        }
        if (currentShardCount() != null) {
            sb.append("CurrentShardCount: ").append(currentShardCount()).append(",");
        }
        if (targetShardCount() != null) {
            sb.append("TargetShardCount: ").append(targetShardCount()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.of(clazz.cast(streamName()));
        case "CurrentShardCount":
            return Optional.of(clazz.cast(currentShardCount()));
        case "TargetShardCount":
            return Optional.of(clazz.cast(targetShardCount()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisResponse.Builder, CopyableBuilder<Builder, UpdateShardCountResponse> {
        /**
         * <p>
         * The name of the stream.
         * </p>
         * 
         * @param streamName
         *        The name of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The current number of shards.
         * </p>
         * 
         * @param currentShardCount
         *        The current number of shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardCount(Integer currentShardCount);

        /**
         * <p>
         * The updated number of shards.
         * </p>
         * 
         * @param targetShardCount
         *        The updated number of shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetShardCount(Integer targetShardCount);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private String streamName;

        private Integer currentShardCount;

        private Integer targetShardCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateShardCountResponse model) {
            streamName(model.streamName);
            currentShardCount(model.currentShardCount);
            targetShardCount(model.targetShardCount);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getCurrentShardCount() {
            return currentShardCount;
        }

        @Override
        public final Builder currentShardCount(Integer currentShardCount) {
            this.currentShardCount = currentShardCount;
            return this;
        }

        public final void setCurrentShardCount(Integer currentShardCount) {
            this.currentShardCount = currentShardCount;
        }

        public final Integer getTargetShardCount() {
            return targetShardCount;
        }

        @Override
        public final Builder targetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
            return this;
        }

        public final void setTargetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
        }

        @Override
        public UpdateShardCountResponse build() {
            return new UpdateShardCountResponse(this);
        }
    }
}
