/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.kinesis.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * StreamDescription JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class StreamDescriptionUnmarshaller implements Unmarshaller<StreamDescription, JsonUnmarshallerContext> {

    public StreamDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        StreamDescription.Builder streamDescriptionBuilder = StreamDescription.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("StreamName", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.streamName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StreamARN", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.streamARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StreamStatus", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.streamStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Shards", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.shards(new ListUnmarshaller<Shard>(ShardUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("HasMoreShards", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.hasMoreShards(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("RetentionPeriodHours", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.retentionPeriodHours(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("StreamCreationTimestamp", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.streamCreationTimestamp(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("EnhancedMonitoring", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.enhancedMonitoring(new ListUnmarshaller<EnhancedMetrics>(EnhancedMetricsUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("EncryptionType", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.encryptionType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("KeyId", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.keyId(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return streamDescriptionBuilder.build();
    }

    private static final StreamDescriptionUnmarshaller INSTANCE = new StreamDescriptionUnmarshaller();

    public static StreamDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
