/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * TBD
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateApplicationRequest extends KinesisAnalyticsRequest implements
        ToCopyableBuilder<CreateApplicationRequest.Builder, CreateApplicationRequest> {
    private final String applicationName;

    private final String applicationDescription;

    private final List<Input> inputs;

    private final List<Output> outputs;

    private final List<CloudWatchLoggingOption> cloudWatchLoggingOptions;

    private final String applicationCode;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.applicationCode = builder.applicationCode;
    }

    /**
     * <p>
     * Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).
     * </p>
     * 
     * @return Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Summary description of the application.
     * </p>
     * 
     * @return Summary description of the application.
     */
    public String applicationDescription() {
        return applicationDescription;
    }

    /**
     * <p>
     * Use this parameter to configure the application input.
     * </p>
     * <p>
     * You can configure your application to receive input from a single streaming source. In this configuration, you
     * map this streaming source to an in-application stream that is created. Your application code can then query the
     * in-application stream like a table (you can think of it as a constantly updating table).
     * </p>
     * <p>
     * For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for
     * example, JSON, CSV, etc). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read this
     * stream on your behalf.
     * </p>
     * <p>
     * To create the in-application stream, you need to specify a schema to transform your data into a schematized
     * version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming
     * source to record columns in the in-app stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Use this parameter to configure the application input.</p>
     *         <p>
     *         You can configure your application to receive input from a single streaming source. In this
     *         configuration, you map this streaming source to an in-application stream that is created. Your
     *         application code can then query the in-application stream like a table (you can think of it as a
     *         constantly updating table).
     *         </p>
     *         <p>
     *         For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream
     *         (for example, JSON, CSV, etc). You also must provide an IAM role that Amazon Kinesis Analytics can assume
     *         to read this stream on your behalf.
     *         </p>
     *         <p>
     *         To create the in-application stream, you need to specify a schema to transform your data into a
     *         schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in
     *         the streaming source to record columns in the in-app stream.
     */
    public List<Input> inputs() {
        return inputs;
    }

    /**
     * <p>
     * You can configure application output to write data from any of the in-application streams to up to five
     * destinations.
     * </p>
     * <p>
     * These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, or both.
     * </p>
     * <p>
     * In the configuration, you specify the in-application stream name, the destination stream Amazon Resource Name
     * (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis Analytics
     * can assume to write to the destination stream on your behalf.
     * </p>
     * <p>
     * In the output configuration, you also provide the output stream Amazon Resource Name (ARN) and the format of data
     * in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon Kinesis Analytics can
     * assume to write to this stream on your behalf.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return You can configure application output to write data from any of the in-application streams to up to five
     *         destinations.</p>
     *         <p>
     *         These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, or both.
     *         </p>
     *         <p>
     *         In the configuration, you specify the in-application stream name, the destination stream Amazon Resource
     *         Name (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon
     *         Kinesis Analytics can assume to write to the destination stream on your behalf.
     *         </p>
     *         <p>
     *         In the output configuration, you also provide the output stream Amazon Resource Name (ARN) and the format
     *         of data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon Kinesis
     *         Analytics can assume to write to this stream on your behalf.
     */
    public List<Output> outputs() {
        return outputs;
    }

    /**
     * <p>
     * Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more
     * information, see <a href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working
     * with Amazon CloudWatch Logs</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For
     *         more information, see <a
     *         href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
     *         CloudWatch Logs</a>.
     */
    public List<CloudWatchLoggingOption> cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * One or more SQL statements that read input data, transform it, and generate output. For example, you can write a
     * SQL statement that reads data from one in-application stream, generates a running average of the number of
     * advertisement clicks by vendor, and insert resulting rows in another in-application stream using pumps. For more
     * inforamtion about the typical pattern, see <a
     * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application Code</a>.
     * </p>
     * <p>
     * You can provide such series of SQL statements, where output of one statement can be used as the input for the
     * next statement. You store intermediate results by creating in-application streams and pumps.
     * </p>
     * <p>
     * Note that the application code must create the streams with names specified in the <code>Outputs</code>. For
     * example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code> and
     * <code>ExampleOutputStream2</code>, then your application code must create these streams.
     * </p>
     * 
     * @return One or more SQL statements that read input data, transform it, and generate output. For example, you can
     *         write a SQL statement that reads data from one in-application stream, generates a running average of the
     *         number of advertisement clicks by vendor, and insert resulting rows in another in-application stream
     *         using pumps. For more inforamtion about the typical pattern, see <a
     *         href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application
     *         Code</a>. </p>
     *         <p>
     *         You can provide such series of SQL statements, where output of one statement can be used as the input for
     *         the next statement. You store intermediate results by creating in-application streams and pumps.
     *         </p>
     *         <p>
     *         Note that the application code must create the streams with names specified in the <code>Outputs</code>.
     *         For example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code>
     *         and <code>ExampleOutputStream2</code>, then your application code must create these streams.
     */
    public String applicationCode() {
        return applicationCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(inputs());
        hashCode = 31 * hashCode + Objects.hashCode(outputs());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(applicationCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(applicationDescription(), other.applicationDescription())
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(outputs(), other.outputs())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions())
                && Objects.equals(applicationCode(), other.applicationCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (applicationDescription() != null) {
            sb.append("ApplicationDescription: ").append(applicationDescription()).append(",");
        }
        if (inputs() != null) {
            sb.append("Inputs: ").append(inputs()).append(",");
        }
        if (outputs() != null) {
            sb.append("Outputs: ").append(outputs()).append(",");
        }
        if (cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(cloudWatchLoggingOptions()).append(",");
        }
        if (applicationCode() != null) {
            sb.append("ApplicationCode: ").append(applicationCode()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.of(clazz.cast(applicationName()));
        case "ApplicationDescription":
            return Optional.of(clazz.cast(applicationDescription()));
        case "Inputs":
            return Optional.of(clazz.cast(inputs()));
        case "Outputs":
            return Optional.of(clazz.cast(outputs()));
        case "CloudWatchLoggingOptions":
            return Optional.of(clazz.cast(cloudWatchLoggingOptions()));
        case "ApplicationCode":
            return Optional.of(clazz.cast(applicationCode()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisAnalyticsRequest.Builder, CopyableBuilder<Builder, CreateApplicationRequest> {
        /**
         * <p>
         * Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).
         * </p>
         * 
         * @param applicationName
         *        Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Summary description of the application.
         * </p>
         * 
         * @param applicationDescription
         *        Summary description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDescription(String applicationDescription);

        /**
         * <p>
         * Use this parameter to configure the application input.
         * </p>
         * <p>
         * You can configure your application to receive input from a single streaming source. In this configuration,
         * you map this streaming source to an in-application stream that is created. Your application code can then
         * query the in-application stream like a table (you can think of it as a constantly updating table).
         * </p>
         * <p>
         * For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for
         * example, JSON, CSV, etc). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read
         * this stream on your behalf.
         * </p>
         * <p>
         * To create the in-application stream, you need to specify a schema to transform your data into a schematized
         * version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming
         * source to record columns in the in-app stream.
         * </p>
         * 
         * @param inputs
         *        Use this parameter to configure the application input.</p>
         *        <p>
         *        You can configure your application to receive input from a single streaming source. In this
         *        configuration, you map this streaming source to an in-application stream that is created. Your
         *        application code can then query the in-application stream like a table (you can think of it as a
         *        constantly updating table).
         *        </p>
         *        <p>
         *        For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream
         *        (for example, JSON, CSV, etc). You also must provide an IAM role that Amazon Kinesis Analytics can
         *        assume to read this stream on your behalf.
         *        </p>
         *        <p>
         *        To create the in-application stream, you need to specify a schema to transform your data into a
         *        schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements
         *        in the streaming source to record columns in the in-app stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<Input> inputs);

        /**
         * <p>
         * Use this parameter to configure the application input.
         * </p>
         * <p>
         * You can configure your application to receive input from a single streaming source. In this configuration,
         * you map this streaming source to an in-application stream that is created. Your application code can then
         * query the in-application stream like a table (you can think of it as a constantly updating table).
         * </p>
         * <p>
         * For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for
         * example, JSON, CSV, etc). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read
         * this stream on your behalf.
         * </p>
         * <p>
         * To create the in-application stream, you need to specify a schema to transform your data into a schematized
         * version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming
         * source to record columns in the in-app stream.
         * </p>
         * 
         * @param inputs
         *        Use this parameter to configure the application input.</p>
         *        <p>
         *        You can configure your application to receive input from a single streaming source. In this
         *        configuration, you map this streaming source to an in-application stream that is created. Your
         *        application code can then query the in-application stream like a table (you can think of it as a
         *        constantly updating table).
         *        </p>
         *        <p>
         *        For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream
         *        (for example, JSON, CSV, etc). You also must provide an IAM role that Amazon Kinesis Analytics can
         *        assume to read this stream on your behalf.
         *        </p>
         *        <p>
         *        To create the in-application stream, you need to specify a schema to transform your data into a
         *        schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements
         *        in the streaming source to record columns in the in-app stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Input... inputs);

        /**
         * <p>
         * You can configure application output to write data from any of the in-application streams to up to five
         * destinations.
         * </p>
         * <p>
         * These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, or both.
         * </p>
         * <p>
         * In the configuration, you specify the in-application stream name, the destination stream Amazon Resource Name
         * (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis
         * Analytics can assume to write to the destination stream on your behalf.
         * </p>
         * <p>
         * In the output configuration, you also provide the output stream Amazon Resource Name (ARN) and the format of
         * data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon Kinesis Analytics
         * can assume to write to this stream on your behalf.
         * </p>
         * 
         * @param outputs
         *        You can configure application output to write data from any of the in-application streams to up to
         *        five destinations.</p>
         *        <p>
         *        These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, or both.
         *        </p>
         *        <p>
         *        In the configuration, you specify the in-application stream name, the destination stream Amazon
         *        Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that
         *        Amazon Kinesis Analytics can assume to write to the destination stream on your behalf.
         *        </p>
         *        <p>
         *        In the output configuration, you also provide the output stream Amazon Resource Name (ARN) and the
         *        format of data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon
         *        Kinesis Analytics can assume to write to this stream on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * <p>
         * You can configure application output to write data from any of the in-application streams to up to five
         * destinations.
         * </p>
         * <p>
         * These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, or both.
         * </p>
         * <p>
         * In the configuration, you specify the in-application stream name, the destination stream Amazon Resource Name
         * (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis
         * Analytics can assume to write to the destination stream on your behalf.
         * </p>
         * <p>
         * In the output configuration, you also provide the output stream Amazon Resource Name (ARN) and the format of
         * data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon Kinesis Analytics
         * can assume to write to this stream on your behalf.
         * </p>
         * 
         * @param outputs
         *        You can configure application output to write data from any of the in-application streams to up to
         *        five destinations.</p>
         *        <p>
         *        These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, or both.
         *        </p>
         *        <p>
         *        In the configuration, you specify the in-application stream name, the destination stream Amazon
         *        Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that
         *        Amazon Kinesis Analytics can assume to write to the destination stream on your behalf.
         *        </p>
         *        <p>
         *        In the output configuration, you also provide the output stream Amazon Resource Name (ARN) and the
         *        format of data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon
         *        Kinesis Analytics can assume to write to this stream on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * <p>
         * Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
         * CloudWatch Logs</a>.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        Use this parameter to configure a CloudWatch log stream to monitor application configuration errors.
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
         *        CloudWatch Logs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions);

        /**
         * <p>
         * Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
         * CloudWatch Logs</a>.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        Use this parameter to configure a CloudWatch log stream to monitor application configuration errors.
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
         *        CloudWatch Logs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOption... cloudWatchLoggingOptions);

        /**
         * <p>
         * One or more SQL statements that read input data, transform it, and generate output. For example, you can
         * write a SQL statement that reads data from one in-application stream, generates a running average of the
         * number of advertisement clicks by vendor, and insert resulting rows in another in-application stream using
         * pumps. For more inforamtion about the typical pattern, see <a
         * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application
         * Code</a>.
         * </p>
         * <p>
         * You can provide such series of SQL statements, where output of one statement can be used as the input for the
         * next statement. You store intermediate results by creating in-application streams and pumps.
         * </p>
         * <p>
         * Note that the application code must create the streams with names specified in the <code>Outputs</code>. For
         * example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code> and
         * <code>ExampleOutputStream2</code>, then your application code must create these streams.
         * </p>
         * 
         * @param applicationCode
         *        One or more SQL statements that read input data, transform it, and generate output. For example, you
         *        can write a SQL statement that reads data from one in-application stream, generates a running average
         *        of the number of advertisement clicks by vendor, and insert resulting rows in another in-application
         *        stream using pumps. For more inforamtion about the typical pattern, see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application
         *        Code</a>. </p>
         *        <p>
         *        You can provide such series of SQL statements, where output of one statement can be used as the input
         *        for the next statement. You store intermediate results by creating in-application streams and pumps.
         *        </p>
         *        <p>
         *        Note that the application code must create the streams with names specified in the
         *        <code>Outputs</code>. For example, if your <code>Outputs</code> defines output streams named
         *        <code>ExampleOutputStream1</code> and <code>ExampleOutputStream2</code>, then your application code
         *        must create these streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCode(String applicationCode);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends KinesisAnalyticsRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String applicationDescription;

        private List<Input> inputs;

        private List<Output> outputs;

        private List<CloudWatchLoggingOption> cloudWatchLoggingOptions;

        private String applicationCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            applicationName(model.applicationName);
            applicationDescription(model.applicationDescription);
            inputs(model.inputs);
            outputs(model.outputs);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            applicationCode(model.applicationCode);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getApplicationDescription() {
            return applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        public final Collection<Input.Builder> getInputs() {
            return inputs != null ? inputs.stream().map(Input::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputs(Collection<Input> inputs) {
            this.inputs = InputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Input... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final void setInputs(Collection<Input.BuilderImpl> inputs) {
            this.inputs = InputsCopier.copyFromBuilder(inputs);
        }

        public final Collection<Output.Builder> getOutputs() {
            return outputs != null ? outputs.stream().map(Output::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputsCopier.copyFromBuilder(outputs);
        }

        public final Collection<CloudWatchLoggingOption.Builder> getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.stream().map(CloudWatchLoggingOption::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copy(cloudWatchLoggingOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOption... cloudWatchLoggingOptions) {
            cloudWatchLoggingOptions(Arrays.asList(cloudWatchLoggingOptions));
            return this;
        }

        public final void setCloudWatchLoggingOptions(Collection<CloudWatchLoggingOption.BuilderImpl> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copyFromBuilder(cloudWatchLoggingOptions);
        }

        public final String getApplicationCode() {
            return applicationCode;
        }

        @Override
        public final Builder applicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
            return this;
        }

        public final void setApplicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }
    }
}
